<?php
/**
 * @Packge     : saor
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    saor_setPostViews( get_the_ID() );

    ?>
    <div <?php post_class(); ?>>
    <?php
        if( class_exists('ReduxFramework') ) {
            $saor_post_details_title_position = saor_opt('saor_post_details_title_position');
        } else {
            $saor_post_details_title_position = 'header';
        }

        $allowhtml = array(
            'p'         => array(
                'class'     => array()
            ),
            'span'      => array(),
            'a'         => array(
                'href'      => array(),
                'title'     => array()
            ),
            'br'        => array(),
            'em'        => array(),
            'strong'    => array(),
            'b'         => array(),
        );
        // Blog Post Thumbnail
        do_action( 'saor_blog_post_thumb' );
        
        echo '<div class="blog-content">';
            // Blog Post Meta
            do_action( 'saor_blog_post_meta' );

            if( $saor_post_details_title_position != 'header' ) {
                echo '<h3 class="blog-title">'.wp_kses( get_the_title(), $allowhtml ).'</h3>';
            }

            if( get_the_content() ){

                the_content();
                // Link Pages
                saor_link_pages();
            }  

            if( class_exists('ReduxFramework') ) {
                $saor_post_details_share_options = saor_opt('saor_post_details_share_options');
                $saor_display_post_tags = saor_opt('saor_display_post_tags');
                $saor_author_options = saor_opt('saor_post_details_author_desc_trigger');
            } else {
                $saor_post_details_share_options = false;
                $saor_display_post_tags = false;
                $saor_author_options = false;
            }
            
            $saor_post_tag = get_the_tags();
            
            if( ! empty( $saor_display_post_tags ) || ( ! empty($saor_post_details_share_options )) ){
                echo '<div class="share-links clearfix">';
                    echo '<div class="row justify-content-between">';
                        if( is_array( $saor_post_tag ) && ! empty( $saor_post_tag ) ){
                            if( count( $saor_post_tag ) > 1 ){
                                $tag_text = __( 'Tags:', 'saor' );
                            }else{
                                $tag_text = __( 'Tag:', 'saor' );
                            }
                            if($saor_display_post_tags){
                                echo '<div class="col-md-auto">';
                                    echo '<span class="share-links-title">'.esc_html($tag_text).'</span>';
                                    echo '<div class="tagcloud">';
                                        foreach( $saor_post_tag as $tags ){
                                            echo '<a href="'.esc_url( get_tag_link( $tags->term_id ) ).'">'.esc_html( $tags->name ).'</a>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            }
                        }
    
                        /**
                        *
                        * Hook for Blog Details Share Options
                        *
                        * Hook saor_blog_details_share_options
                        *
                        * @Hooked saor_blog_details_share_options_cb 10
                        *
                        */
                        do_action( 'saor_blog_details_share_options' );
    
                    echo '</div>';
    
                echo '</div>';    
            }  
        
        echo '</div>';

    echo '</div>'; 

        /**
        *
        * Hook for Post Navigation
        *
        * Hook saor_blog_details_post_navigation
        *
        * @Hooked saor_blog_details_post_navigation_cb 10
        *
        */
        do_action( 'saor_blog_details_post_navigation' );

        /**
        *
        * Hook for Blog Authro Bio
        *
        * Hook saor_blog_details_author_bio
        *
        * @Hooked saor_blog_details_author_bio_cb 10
        *
        */
        do_action( 'saor_blog_details_author_bio' );

        /**
        *
        * Hook for Blog Details Comments
        *
        * Hook saor_blog_details_comments
        *
        * @Hooked saor_blog_details_comments_cb 10
        *
        */
        do_action( 'saor_blog_details_comments' );
