<?php

/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */

 /**
 * Only return default value if we don't have a post ID (in the 'post' query variable)
 *
 * @param  bool  $default On/Off (true/false)
 * @return mixed          Returns true or '', the blank default
 */
function saor_set_checkbox_default_for_new_post( $default ) {
	return isset( $_GET['post'] ) ? '' : ( $default ? (string) $default : '' );
}

add_action( 'cmb2_admin_init', 'saor_register_metabox' );

/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_admin_init' or 'cmb2_init' hook.
 */

function saor_register_metabox() {

	$prefix = '_saor_';

	$prefixpage = '_saorpage_';
	
	$saor_post_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'blog_post_control',
		'title'         => esc_html__( 'Post Thumb Controller', 'saor' ),
		'object_types'  => array( 'post' ), // Post type
		'closed'        => true
	) );

    $saor_post_meta->add_field( array(
        'name' => esc_html__( 'Post Format Video', 'saor' ),
        'desc' => esc_html__( 'Use This Field When Post Format Video', 'saor' ),
        'id'   => $prefix . 'post_format_video',
        'type' => 'text_url',
    ) );

	$saor_post_meta->add_field( array(
		'name' => esc_html__( 'Post Format Audio', 'saor' ),
		'desc' => esc_html__( 'Use This Field When Post Format Audio', 'saor' ),
		'id'   => $prefix . 'post_format_audio',
        'type' => 'oembed',
    ) );
	$saor_post_meta->add_field( array(
		'name' => esc_html__( 'Post Thumbnail For Slider', 'saor' ),
		'desc' => esc_html__( 'Use This Field When You Want A Slider In Post Thumbnail', 'saor' ),
		'id'   => $prefix . 'post_format_slider',
        'type' => 'file_list',
    ) );
	
	$saor_page_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_meta_section',
		'title'         => esc_html__( 'Page Meta', 'saor' ),
		'object_types'  => array( 'page'), // Post type
        'closed'        => true
    ) );

    $saor_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Area', 'saor' ),
		'desc' => esc_html__( 'check to display page breadcrumb area.', 'saor' ),
		'id'   => $prefix . 'page_breadcrumb_area',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   => esc_html__('Show','saor'),
            '2'     => esc_html__('Hide','saor'),
        )
    ) );


    $saor_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Settings', 'saor' ),
		'id'   => $prefix . 'page_breadcrumb_settings',
        'type' => 'select',
        'default'   => 'global',
        'options'   => array(
            'global'   => esc_html__('Global Settings','saor'),
            'page'     => esc_html__('Page Settings','saor'),
        )
	) );

    $saor_page_meta->add_field( array(
        'name'    => esc_html__( 'Breadcumb Image', 'saor' ),
        'desc'    => esc_html__( 'Upload an image or enter an URL.', 'saor' ),
        'id'      => $prefix . 'breadcumb_image',
        'type'    => 'file',
        // Optional:
        'options' => array(
            'url' => false, // Hide the text input for the url
        ),
        'text'    => array(
            'add_upload_file_text' => __( 'Add File', 'saor' ) // Change upload button text. Default: "Add or Upload File"
        ),
        'preview_size' => 'large', // Image size to use when previewing in the admin.
    ) );

    $saor_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title', 'saor' ),
		'desc' => esc_html__( 'check to display Page Title.', 'saor' ),
		'id'   => $prefix . 'page_title',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   => esc_html__('Show','saor'),
            '2'     => esc_html__('Hide','saor'),
        )
	) );

    $saor_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title Settings', 'saor' ),
		'id'   => $prefix . 'page_title_settings',
        'type' => 'select',
        'options'   => array(
            'default'  => esc_html__('Default Title','saor'),
            'custom'  => esc_html__('Custom Title','saor'),
        ),
        'default'   => 'default'
    ) );

    $saor_page_meta->add_field( array(
		'name' => esc_html__( 'Custom Page Title', 'saor' ),
		'id'   => $prefix . 'custom_page_title',
        'type' => 'text'
    ) );

    $saor_page_meta->add_field( array(
		'name' => esc_html__( 'Breadcrumb', 'saor' ),
		'desc' => esc_html__( 'Select Show to display breadcrumb area', 'saor' ),
		'id'   => $prefix . 'page_breadcrumb_trigger',
        'type' => 'switch_btn',
        'default' => saor_set_checkbox_default_for_new_post( true ),
    ) );

    $saor_layout_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_layout_section',
		'title'         => esc_html__( 'Page Layout', 'saor' ),
        'context' 		=> 'side',
        'priority' 		=> 'high',
        'object_types'  => array( 'page', ), // Post type
        'closed'        => true
	) );

	$saor_layout_meta->add_field( array(
		'desc'       => esc_html__( 'Set page layout container,container fluid,fullwidth or both. It\'s work only in template builder page.', 'saor' ),
		'id'         => $prefix . 'custom_page_layout',
		'type'       => 'radio',
        'options' => array(
            '1' => esc_html__( 'Container', 'saor' ),
            '2' => esc_html__( 'Container Fluid', 'saor' ),
            '3' => esc_html__( 'Fullwidth', 'saor' ),
        ),
	) );

	// code for body class//

    $saor_layout_meta->add_field( array(
    	'name' => esc_html__( 'Insert Your Body Class', 'saor' ),
    	'id'   => $prefix . 'custom_body_class',
    	'type' => 'text'
    ) );


    $saor_extra_listing_meta = new_cmb2_box( array(
        'id'            => $prefixpage . 'listingmeta_section',
        'title'         => esc_html__( 'Additional Informations', 'saor' ),
        'object_types'  => array( 'at_biz_dir' ), // Post type
        'closed'        => true,
        'context'       => 'side',
        'priority'      => 'default'
    ) );

    $saor_extra_listing_meta->add_field( array(
        'name' => esc_html__( 'Address', 'saor' ),
        'id'   => $prefix . 'saor_address',
        'type' => 'text'
    ) );
    $saor_extra_listing_meta->add_field( array(
        'name' => esc_html__( 'Short Description', 'saor' ),
        'id'   => $prefix . 'saor_short_description',
        'type' => 'textarea'
    ) );
    $saor_extra_listing_meta->add_field( array(
        'name' => esc_html__( 'Bad Room', 'saor' ),
        'id'   => $prefix . 'saor_bed_count',
        'type' => 'text'
    ) );
    $saor_extra_listing_meta->add_field( array(
        'name' => esc_html__( 'Bath Room', 'saor' ),
        'id'   => $prefix . 'saor_bath_count',
        'type' => 'text'
    ) );
    $saor_extra_listing_meta->add_field( array(
        'name' => esc_html__( 'Room Size', 'saor' ),
        'id'   => $prefix . 'saor_room_size',
        'type' => 'text'
    ) );

}

add_action( 'cmb2_admin_init', 'saor_register_taxonomy_metabox' );
/**
 * Hook in and add a metabox to add fields to taxonomy terms
 */
function saor_register_taxonomy_metabox() {

    $prefix = '_saor_';
	/**
	 * Metabox to add fields to categories and tags
	 */
	$saor_term_meta = new_cmb2_box( array(
		'id'               => $prefix.'term_edit',
		'title'            => esc_html__( 'Category Metabox', 'saor' ),
		'object_types'     => array( 'term' ),
		'taxonomies'       => array( 'category'),
	) );
	$saor_term_meta->add_field( array(
		'name'     => esc_html__( 'Extra Info', 'saor' ),
		'id'       => $prefix.'term_extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );
	$saor_term_meta->add_field( array(
		'name' => esc_html__( 'Category Image', 'saor' ),
		'desc' => esc_html__( 'Set Category Image', 'saor' ),
		'id'   => $prefix.'term_avatar',
        'type' => 'file',
        'text'    => array(
			'add_upload_file_text' => esc_html__('Add Image','saor') // Change upload button text. Default: "Add or Upload File"
		),
	) );


	/**
	 * Metabox for the user profile screen
	 */
	$saor_user = new_cmb2_box( array(
		'id'               => $prefix.'user_edit',
		'title'            => esc_html__( 'User Profile Metabox', 'saor' ), // Doesn't output for user boxes
		'object_types'     => array( 'user' ), // Tells CMB2 to use user_meta as post_meta
		'show_names'       => true,
		'new_user_section' => 'add-new-user', // where form will show on new user page. 'add-existing-user' is only other valid option.
	) );
    $saor_user->add_field( array(
		'name' => esc_html__( 'Author Designation', 'saor' ),
		'desc' => esc_html__( 'Use This Field When Author Designation', 'saor' ),
		'id'   => $prefix . 'author_desig',
        'type' => 'text',
    ) );
	$saor_user->add_field( array(
		'name'     => esc_html__( 'Social Profile', 'saor' ),
		'id'       => $prefix.'user_extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );

	$group_field_id = $saor_user->add_field( array(
        'id'          => $prefix .'social_profile_group',
        'type'        => 'group',
        'description' => __( 'Social Profile', 'saor' ),
        'options'     => array(
            'group_title'       => __( 'Social Profile {#}', 'saor' ), // since version 1.1.4, {#} gets replaced by row number
            'add_button'        => __( 'Add Another Social Profile', 'saor' ),
            'remove_button'     => __( 'Remove Social Profile', 'saor' ),
            'closed'         => true
        ),
    ) );

    $saor_user->add_group_field( $group_field_id, array(
        'name'        => __( 'Icon Class', 'saor' ),
        'id'          => $prefix .'social_profile_icon',
        'type'        => 'text', // This field type
    ) );

    $saor_user->add_group_field( $group_field_id, array(
        'desc'       => esc_html__( 'Set social profile link.', 'saor' ),
        'id'         => $prefix . 'lawyer_social_profile_link',
        'name'       => esc_html__( 'Social Profile link', 'saor' ),
        'type'       => 'text'
    ) );
}
