<?php
/**
 * @Packge     : saor
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

// Block direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Enqueue scripts and styles.
 */
function saor_essential_scripts() {

    wp_enqueue_style( 'saor-style', get_stylesheet_uri() ,array(), wp_get_theme()->get( 'Version' ) ); 

    // google font
    wp_enqueue_style( 'saor-fonts', saor_google_fonts() ,array(), null );

    // Bootstrap Min
    wp_enqueue_style( 'bootstrap', get_theme_file_uri( '/assets/css/bootstrap.min.css' ) ,array(), '5.0.0' );

    // Font Awesome Six
    wp_enqueue_style( 'fontawesome', get_theme_file_uri( '/assets/css/fontawesome.min.css' ) ,array(), '6.0.0' );

    // Magnific Popup
    wp_enqueue_style( 'magnific-popup', get_theme_file_uri( '/assets/css/magnific-popup.min.css' ), array(), '1.0' );

    // Swiper css
    wp_enqueue_style( 'swiper-css', get_theme_file_uri( '/assets/css/swiper-bundle.min.css' ) ,array(), '4.0.13' );

    // imageRevealHover css
    wp_enqueue_style( 'imageRevealHover-css', get_theme_file_uri( '/assets/css/imageRevealHover.css' ) ,array(), '4.0.13' );

    // saor main style
    wp_enqueue_style( 'saor-main-style', get_theme_file_uri('/assets/css/style.css') ,array(), wp_get_theme()->get( 'Version' ) );

    // swiper js
    wp_enqueue_script( 'swiper-js', get_theme_file_uri( '/assets/js/swiper-bundle.min.js' ), array('jquery'), '1.0.0', true );
      // Bootstrap
    wp_enqueue_script( 'bootstrap', get_theme_file_uri( '/assets/js/bootstrap.min.js' ), array( 'jquery' ), '5.0.0', true );

    // magnific popup
    wp_enqueue_script( 'magnific-popup', get_theme_file_uri( '/assets/js/jquery.magnific-popup.min.js' ), array('jquery'), '1.0.0', true );

    // Counterup
    wp_enqueue_script( 'counterup', get_theme_file_uri( '/assets/js/jquery.counterup.min.js' ), array( 'jquery' ), '3.3.3', true );

     // Circle Progress
    wp_enqueue_script( 'circle-progress', get_theme_file_uri( '/assets/js/circle-progress.js' ), array( 'jquery' ), '3.3.3', true );

    // Isotope
    wp_enqueue_script( 'isototpe-pkgd', get_theme_file_uri( '/assets/js/isotope.pkgd.min.js' ), array( 'jquery' ), '1.0.0', true );

    // jquery-ui
    wp_enqueue_script( 'jquery-ui-slider' );

     // tilt
    wp_enqueue_script( 'tilt', get_theme_file_uri( '/assets/js/tilt.jquery.min.js' ), array( 'jquery' ), '1.0.0', true );

    // Isotope Imagesloaded
    wp_enqueue_script( 'imagesloaded' ); 

    // Nice Select
    wp_enqueue_script( 'nice-select', get_theme_file_uri( '/assets/js/nice-select.min.js' ), array( 'jquery' ), '1.0.0', true );

    // Custom Gsap
    if( class_exists( 'ReduxFramework' ) ) {
        $display_gsap = saor_opt('saor_display_gsap_animation');
        if($display_gsap){
            wp_enqueue_script( 'custom-gsap', get_theme_file_uri( '/assets/js/custom-gsap.js' ), array( 'jquery' ), '1.0.0', true );
        }
    }else{
            wp_enqueue_script( 'custom-gsap', get_theme_file_uri( '/assets/js/custom-gsap.js' ), array( 'jquery' ), '1.0.0', true );
    }



    // Wow
    wp_enqueue_script( 'wow', get_theme_file_uri( '/assets/js/wow.min.js' ), array( 'jquery' ), '1.0.0', true );

    // Particles
    wp_enqueue_script( 'particles', get_theme_file_uri( '/assets/js/particles.min.js' ), array( 'jquery' ), '1.0.0', true );

    // Particles Config
    wp_enqueue_script( 'particles-config', get_theme_file_uri( '/assets/js/particles-config.js' ), array( 'jquery' ), '1.0.0', true );

    // Gsap
    wp_enqueue_script( 'gsap', get_theme_file_uri( '/assets/js/gsap.min.js' ), array( 'jquery' ), '1.0.0', true );

     // imageRevealHover
    wp_enqueue_script( 'imageRevealHover', get_theme_file_uri( '/assets/js/imageRevealHover.js' ), array( 'jquery' ), '1.0.0', true );

    // ScrollTrigger
    wp_enqueue_script( 'ScrollTrigger', get_theme_file_uri( '/assets/js/ScrollTrigger.min.js' ), array( 'jquery' ), '1.0.0', true );

    // Splitetext
    wp_enqueue_script( 'Splitetext', get_theme_file_uri( '/assets/js/Splitetext.js' ), array( 'jquery' ), '1.0.0', true );

    // main script
    wp_enqueue_script( 'saor-main-script', get_theme_file_uri( '/assets/js/main.js' ), array('jquery'), wp_get_theme()->get( 'Version' ), true );

    // comment reply
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_enqueue_scripts', 'saor_essential_scripts',99 );


function saor_block_editor_assets( ) {
    // Add custom fonts.
    wp_enqueue_style( 'saor-editor-fonts', saor_google_fonts(), array(), null );
}

add_action( 'enqueue_block_editor_assets', 'saor_block_editor_assets' );

/*
Register Fonts
*/
function saor_google_fonts() {
    $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
     
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'saor' ) ) {
        $font_url =  'https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&family=Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Space+Grotesk:wght@300..700&display=swap';
    }
    return $font_url;
}