<?php
/**
 * @Packge     : saor
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

// Block direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Include File
 *
 */

// Constants
require_once get_parent_theme_file_path() . '/inc/saor-constants.php';

//theme setup
require_once SAOR_DIR_PATH_INC . 'theme-setup.php';

//essential scripts
require_once SAOR_DIR_PATH_INC . 'essential-scripts.php';

// Woo Hooks
require_once SAOR_DIR_PATH_INC . 'woo-hooks/saor-woo-hooks.php';

// Woo Hooks Functions
require_once SAOR_DIR_PATH_INC . 'woo-hooks/saor-woo-hooks-functions.php';

// plugin activation
require_once SAOR_DIR_PATH_FRAM . 'plugins-activation/saor-active-plugins.php';

// theme dynamic css
require_once SAOR_DIR_PATH_INC . 'saor-commoncss.php';

// meta options
require_once SAOR_DIR_PATH_FRAM . 'saor-meta/saor-config.php';

// page breadcrumbs
require_once SAOR_DIR_PATH_INC . 'saor-breadcrumbs.php';

// sidebar register
require_once SAOR_DIR_PATH_INC . 'saor-widgets-reg.php';

//essential functions
require_once SAOR_DIR_PATH_INC . 'saor-functions.php';

// helper function
require_once SAOR_DIR_PATH_INC . 'wp-html-helper.php';

// Demo Data
require_once SAOR_DEMO_DIR_PATH . 'demo-import.php';

// pagination
require_once SAOR_DIR_PATH_INC . 'wp_bootstrap_pagination.php';

// saor options
require_once SAOR_DIR_PATH_FRAM . 'saor-options/saor-options.php';

// hooks
require_once SAOR_DIR_PATH_HOOKS . 'hooks.php';

// hooks funtion
require_once SAOR_DIR_PATH_HOOKS . 'hooks-functions.php'; 


add_action('wp_ajax_update_cart_count', 'update_cart_count');
add_action('wp_ajax_nopriv_update_cart_count', 'update_cart_count');

function update_cart_count() {
    if (class_exists('woocommerce')) {
        global $woocommerce;
        $product_id = intval($_POST['product_id']);
        $woocommerce->cart->add_to_cart($product_id); // Add the product to the cart

        $cart_count = $woocommerce->cart->cart_contents_count;
        echo esc_html($cart_count);
    }
    wp_die();
}


// Temporary NASS debug logging
add_action('init', function() {
    if (!empty($_GET) && (isset($_GET['status']) || isset($_GET['orderId']))) {
        error_log('=== NASS Payment Return ===');
        error_log('URL: ' . $_SERVER['REQUEST_URI']);
        error_log('GET Params: ' . print_r($_GET, true));
        error_log('========================');
    }
});

// Temporary debug for NASS returns
add_action('init', function() {
    if (isset($_GET['wc-api']) && $_GET['wc-api'] === 'nass_payment_return') {
        error_log('NASS Return Received: ' . json_encode($_GET));
    }
});
