<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Video Widget .
 *
 */
class Saor_Video extends Widget_Base {

	public function get_name() {
		return 'saorvideo';
	}
	public function get_title() {
		return __( 'Video Box', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'video_section',
			[
				'label' 	=> __( 'video Box', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two'] ); 

		saor_media_fields( $this, 'image1', 'Choose Image One', [ '1','2'] );
		saor_general_fields( $this, 'icon', 'Icon', 'TEXTAREA2', '<i class="fa-regular fa-play"></i>',[ '1','2'] );
		saor_url_fields( $this, 'video_url', 'Video URL',[ '1','2'] );

		$counter_list = new Repeater();

        saor_general_fields($counter_list, 'title', 'Title', 'TEXTAREA2', 'Default Title');
        saor_general_fields($counter_list, 'number', 'Number', 'TEXTAREA2', '12');
        saor_general_fields($counter_list, 'sufix', 'Sufix', 'TEXTAREA2', 'K');
        saor_general_fields($counter_list, 'prefix', 'Prefix', 'TEXTAREA2', '+');

        $this->add_control(
            'counter_list',
            [
                'label'         => __( 'Counter List', 'saor' ),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $counter_list->get_controls(),
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout_style' => ['2']
                ]
            ]
        );

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		saor_common_style_fields($this, '04', 'Title', '{{WRAPPER}} .sec-title', ['2', '3', '4'] );
		saor_common_style_fields($this, '05', 'Description', '{{WRAPPER}} .sec-text', ['3', '4'] );
		//-------Number Style-------
		saor_common_style_fields($this, '01', 'Number', '{{WRAPPER}} .box-number .counter-number,{{WRAPPER}} .counter-box3 .box-number', ['2', '3', '4'] );
		saor_common_style_fields($this, '02', 'Number Prefix', '{{WRAPPER}} .box-number,{{WRAPPER}} .counter-box3 .counter-text', ['2', '3', '4']);
		//-------Title Style-------
		saor_common_style_fields($this, '03', 'Content', '{{WRAPPER}} .box-text', ['2', '3', '4']);
	
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1'){
            if(!empty($settings['video_url']['url'])){
            echo '<div class="choose-wrapper">';	
	            echo '<div class="video-box1">';
	            	echo saor_img_tag( array(
						'url'   => esc_url( $settings['image1']['url'] ),
					));
	            	if($settings['video_url']['url']){
	                	echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="play-btn popup-video">'.wp_kses_post($settings['icon']).'</a>';
	                }	
	            echo '</div>';
	        echo '</div>';
	        }

	    }elseif( $settings['layout_style'] == '2'){

	    	echo '<div class="row gy-4">';
	    	 	if(!empty($settings['video_url']['url'])){
	                echo '<div class="col-lg-9">';
	                    echo '<div class="video-box1">';
	                       	echo saor_img_tag( array(
								'url'   => esc_url( $settings['image1']['url'] ),
							));
	                        echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="play-btn popup-video">'.wp_kses_post($settings['icon']).'</a>';
	                    echo '</div>';
	                echo '</div>';
	            }
                echo '<div class="col-lg-3">';
                    echo '<div class="counter-box3-wrap">';
                    	foreach( $settings['counter_list'] as $key => $data ){
	                        echo '<div class="counter-box3">';
	                        	if(!empty($data['number'])){
	                            	echo '<h3 class="box-number"><span class="counter-number">'.esc_html($data['number']).'</span>'.esc_html($data['sufix']).'<span class="plus">'.esc_html($data['prefix']).'</span></h3>';
	                            }
	                            if(!empty($data['title'])){
		                            echo '<div class="media-body">';
		                                echo '<p class="counter-text mb-n1">'.esc_html($data['title']).'</p>';
		                            echo '</div>';
		                        }    
	                        echo '</div>';
	                    }    
                    echo '</div>';
                echo '</div>';
            echo '</div>';


		}


	}

}