<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
/**
 *
 * Team Info Widget
 *
 */
class Saor_Team_Info extends Widget_Base{

	public function get_name() {
		return 'saorteaminfo';
	}
	public function get_title() {
		return esc_html__( 'Team Member Info', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'team_member_content',
			[
				'label'		=> esc_html__( 'Member Info','saor' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two' ] );

		saor_general_fields( $this, 'name', 'Member Name', 'TEXT', 'Jonson Anderson', ['1'] );
		saor_general_fields( $this, 'designation', 'Designation', 'TEXT', 'Designation', ['1'] );
		saor_general_fields( $this, 'description', 'Description', 'TEXTAREA', 'Description', ['1'] );
		saor_general_fields( $this, 'social', 'Social', 'TEXTAREA', 'Social', ['1'] );

		$info_list = new Repeater();

		saor_general_fields($info_list, 'title', 'Title', 'TEXTAREA2', 'Default Title');
		saor_general_fields($info_list, 'info', 'Info', 'TEXTAREA2', 'Default Info');
		saor_general_fields($info_list, 'icon', 'Icon', 'TEXTAREA2', 'Icon');

		$this->add_control(
			'info_list',
			[
				'label' 		=> __( 'Info List', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $info_list->get_controls(),
				'title_field' => '{{{ title }}}',
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);
		

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
		saor_common_style_fields( $this, '01', 'Name', '{{WRAPPER}} .box-title',['1','2']   );
		saor_common_style_fields( $this, '02', 'Designation', '{{WRAPPER}} .box-desig, team-about_desig',['1','2'] );
		saor_common_style_fields( $this, '022', 'Summary', '{{WRAPPER}} .team-about_text',['1','2']  );

		saor_common_style_fields( $this, '03', 'Contact Info Title', '{{WRAPPER}} .about-info_title',['2']);
		saor_common_style_fields( $this, '04', 'Contact Info Sub-Title', '{{WRAPPER}} .about-info_subtitle',['2']);

	}

	protected function render() {

	$settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){
            echo '<div class="team-wrapp">';
                echo '<div>';
                    if(!empty($settings['name'])){
                    	echo '<h3 class="team-about_title">'.esc_html($settings['name']).'</h3>';
                    }
                    if(!empty($settings['designation'])){	
                    	echo '<p class="team-about_desig">'.esc_html($settings['designation']).'</p>';
                    }	
                echo '</div>';
                if(!empty($settings['social'])){
	                echo '<div class="th-social">';
	                    echo wp_kses_post($settings['social']);
	                echo '</div>';
                }
            echo '</div>';

            if(!empty($settings['description'])){
            	echo '<p class="team-about_text">'.esc_html($settings['description']).'</p>';
            }	
		}elseif($settings['layout_style'] == '2'){

		    echo '<div class="about-info-wrap">';
		    	foreach( $settings['info_list'] as $key => $data ){
	                echo '<div class="about-info">';
	                	if(!empty($data['icon'])):
		                    echo '<div class="about-info_icon">';
		                    	echo wp_kses_post($data['icon']);
		                    echo'</div>';
	                    endif;
	                    echo '<div class="about-info_content">';
	                    	if(!empty($data['title'])):
		                        echo '<p class="about-info_subtitle">'.wp_kses_post($data['title']).'</p>';
		                    endif;
		                    if(!empty($data['info'])):
	                        	echo '<h6 class="about-info_title">'.wp_kses_post($data['info']).'</h6>';
	                        endif;
	                    echo '</div>';
	                echo '</div>';
                }
            echo '</div>';   
		}	
	}
}