<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Slider Widget.
 *
 */
class Saor_Banner extends Widget_Base {

	public function get_name() {
		return 'saorbanner';
	}
	public function get_title() {
		return __( 'Banner Slider', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'banner_section',
			[
				'label' 	=> __( 'Banner Slider', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', ['Style One','Style Two','Style Three','Style Four','Style Five','Style Six','Style Seven'] ); 

		saor_general_fields( $this, 'title', 'Title', 'TEXTAREA', 'Title One', ['1','2','3','4','5','7']);
		saor_general_fields( $this, 'title2', 'Title', 'TEXTAREA', 'Title One', ['2']);
		saor_general_fields( $this, 'subtitle', 'SubTitle', 'TEXTAREA', 'SubTitle', ['1','2','3','4','5','7']);
		saor_general_fields( $this, 'hero_title', 'Hero Title', 'TEXTAREA', 'Hero Title', ['5']);
		saor_general_fields( $this, 'hero_link', 'Hero Link Title', 'TEXTAREA', 'Hero Link Title', ['5']);
		saor_general_fields( $this, 'summary', 'Summary', 'TEXTAREA', 'Summary', ['1','2','3','4','5','7']);
		saor_general_fields( $this, 'button_text_one', 'Button Text One', 'TEXT2', 'Button Text One', ['1','2','3','4','5']);
		saor_url_fields($this, 'button_url_one', 'Button URL One', ['1','2','3','4','5']);
		saor_general_fields( $this, 'button_text_two', 'Button Text Two', 'TEXT2', 'Button Text One', ['3','4']);
		saor_url_fields($this, 'button_url_two', 'Button URL Two', ['3','4']);

		saor_general_fields( $this, 'video_text', 'Video Text', 'TEXT2', 'video Text', ['2']);
		saor_url_fields($this, 'video_url', 'video URL', ['2','5']);

		saor_general_fields( $this, 'team_text', 'Team Text', 'TEXT', 'Team Text', ['1','2']);

		saor_media_fields( $this, 'image1', 'Choose Image One', ['1','2','3','4','5','7'] );
		saor_media_fields( $this, 'image2', 'Choose Image Two', ['1','2','3','4','5','7'] );
		saor_media_fields( $this, 'image3', 'Choose Image Three', ['1','2','3','5','7'] );
		saor_media_fields( $this, 'image4', 'Choose Image Four', ['1','2','3','5','7'] );
		saor_media_fields( $this, 'image5', 'Choose Image Five', ['1','2','3','5','7'] );
		saor_media_fields( $this, 'image6', 'Choose Image Six', ['1','2','5','7'] );
		saor_media_fields( $this, 'image7', 'Choose Image Seven', ['2','5','7'] );
		saor_media_fields( $this, 'image8', 'Choose Image Eight', ['5','7'] );

		saor_media_fields( $this, 'client_image', 'Client Image', ['5'] );
		saor_general_fields( $this, 'satisfy_client', 'Satisfy Client', 'TEXTAREA', 'Satisfy Client', ['5']);
		saor_general_fields( $this, 'client_title', 'Client Title', 'TEXTAREA', 'Client Title', ['5','7']);

		$client_team_list = new Repeater();

		saor_media_fields($client_team_list, 'image', 'Image One');

		$this->add_control(
			'client_team_list',
			[
				'label' 		=> __( 'Client Team List', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $client_team_list->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Client Team List', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['5','7']
				]
			]
		);


		$slider_list = new Repeater();

		saor_general_fields( $slider_list, 'title', 'Title', 'TEXTAREA', 'Title');
		saor_general_fields( $slider_list, 'subtitle', 'SubTitle', 'TEXTAREA', 'SubTitle');
		saor_general_fields( $slider_list, 'summary', 'Summary', 'TEXTAREA', 'Summary');
		saor_general_fields( $slider_list, 'button_text', 'Button Text One', 'TEXT2', 'Button Text');
		saor_url_fields($slider_list, 'button_url', 'Button URL');
		saor_media_fields($slider_list, 'image', 'Image');
		saor_media_fields($slider_list, 'shape', 'Shape');

		$this->add_control(
			'slider_list',
			[
				'label' 		=> __( 'Slider List', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $slider_list->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Slider List', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['6']
				]
			]
		);

		saor_general_fields( $this, 'social', 'Social', 'TEXTAREA', 'Social',['6','7']);

		saor_media_fields($this, 'shape1', 'Shape One',['6']);
		saor_media_fields($this, 'shape2', 'Shape Two',['6']);
		saor_media_fields($this, 'shape3', 'Shape Three',['6']);
		saor_media_fields($this, 'shape4', 'Shape Four',['6']);

		saor_general_fields( $this, 'client_number', 'Client Number', 'TEXTAREA', 'Client Number', ['5']);

		$this->end_controls_section();	

		saor_common_style_fields( $this, '01', 'Title', '{{WRAPPER}} .hero-title', ['1','4','5','6'] );
		saor_common_style_fields( $this, '111', 'Highlight Title', '{{WRAPPER}} .text-theme', ['1','4','5'] );
		saor_common_style_fields( $this, '02', 'SubTitle', '{{WRAPPER}} .sub-title,{{WRAPPER}} .square-text,{{WRAPPER}} .hero-subtitle', ['1','4','5','6'] );
		saor_common_style_fields( $this, '03', 'Summary', '{{WRAPPER}} .hero-text', ['1','4','5','6'] );

		saor_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th-btn.blue-btn', ['1','4','5'] );
		saor_button_style_fields( $this, '11', 'Button Two Styling', '{{WRAPPER}} .th-btn', ['1','4','5','6'] );
    }

	protected function render() {

    $settings = $this->get_settings_for_display();

		if($settings['layout_style'] == '1'){
		    echo '<div class="th-hero-wrapper hero-1 bg-white background-image shape-mockup-wrap" style="background-image: url('.esc_url( $settings['image1']['url'] ).')">';
		         echo '<div class="container">';
		             echo '<div class="row align-items-end">';
		                 echo '<div class="col-xl-6">';
		                     echo '<div class="hero-style1">';
		                     	if(!empty($settings['subtitle'])): 
		                         	echo '<span class="sub-title text-ani-style2">'. wp_kses_post( $settings['subtitle'] ).'</span>';
		                        endif; 
		                        if(!empty($settings['title'])):
		                            echo '<h1 class="hero-title text-ani-style3">'. wp_kses_post( $settings['title'] ).'</h1>';
		                        endif; 
		                        if(!empty($settings['summary'])):
		                        	echo '<p class="hero-text">'. wp_kses_post( $settings['summary'] ).'</p>';
								endif;
								if(!empty($settings['button_text_one'])){ 
			                        echo '<div class="btn-group">';
			                            echo '<a href="'.esc_url($settings['button_url_one']['url']).'" class="th-btn th-icon th-black2">'. wp_kses_post( $settings['button_text_one'] ).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
			                        echo '</div>';
			                    }    
		                     echo '</div>';
		                 echo '</div>';
		                 echo '<div class="col-xl-6">';
		                     echo '<div class="hero-wrapp">';
		                         echo '<div class="hero-img">';

		                             echo '<img class="movingX" src="'.esc_url( $settings['image2']['url'] ).'" alt="Hero Image">';

		                             echo '<div class="th-hero-shape"></div>';
		                             echo '<div class="th-hero-shape2"></div>';
		                             echo '<div class="th-hero-shape3"></div>';
		                         echo '</div>';
		                         echo '<div class="client-box mb-sm-0 mb-3">';
		                            echo ' <h4 class="box-title">'. wp_kses_post( $settings['team_text'] ).'</h4>';
		                            echo '<div class="client-thumb-group">';
		                            	foreach( $settings['team_list'] as $data ){
		                                	echo '<div class="thumb">'. saor_img_tag( array('url'   => esc_url( $data['image']['url'] ))).'</div>';
		                               	}
		                                echo '<div class="thumb icon"><i class="fa-regular fa-plus"></i></div>';
		                            echo '</div>';
		                        echo '</div>';
		                    echo ' </div>';
		                 echo '</div>';
		             echo '</div>';
		        echo '</div>';
		        if(!empty($settings['image3']['url'])): 
        			echo ' <div class="shape-mockup spin  d-none d-xl-block" data-top="30%" data-left="45%">'. saor_img_tag( array(
						'url'   => esc_url( $settings['image3']['url'] ),
					)).'</div>';
        		endif;
        		if(!empty($settings['image4']['url'])): 	
		        	echo '<div class="shape-mockup moving  d-none d-xl-block" data-top="34%" data-right="13%">'. saor_img_tag( array(
						'url'   => esc_url( $settings['image4']['url'] ),
					)).'</div>';
		        endif;
		        if(!empty($settings['image5']['url'])): 
        			echo '<div class="shape-mockup jump d-none d-xxl-block" data-bottom="16%" data-right="47%">'. saor_img_tag( array(
						'url'   => esc_url( $settings['image5']['url'] ),
					)).'</div>';
 				endif;
 				if(!empty($settings['image6']['url'])): 
        			echo ' <div class="shape-mockup d-none d-xxl-block" data-bottom="13%" data-left="43%">'. saor_img_tag( array(
						'url'   => esc_url( $settings['image6']['url'] ),
					)).'</div>';
        		endif;	
		     echo '</div>';

		}elseif($settings['layout_style'] == '2'){
			echo '<div class="th-hero-wrapper hero-2" id="hero" data-bg-src="'.esc_url( $settings['image1']['url'] ).'">';
		        echo '<div class="container">';
		            echo '<div class="row align-items-center">';
		                echo '<div class="col-xl-6">';
		                    echo '<div class="hero-style2">';
		                        echo '<span class="sub-title"><span class="square-text">
		                                <span class="dot1"></span><span class="dot2"></span>'. wp_kses_post( $settings['subtitle'] ).'</span></span>';
		                                if(!empty($settings['title'])){   
		                        			echo '<h1 class="hero-title text-ani-style3"><span>'. wp_kses_post( $settings['title'] ).' <span class="hero-box">';
		                        		}	
	                                    echo '<span class="client-thumb-group">';
	                                        foreach( $settings['team_list'] as $data ){
			                                	echo '<span class="thumb">'. saor_img_tag( array('url'   => esc_url( $data['image']['url'] ))).'</span>';
			                               	}
			                            if(!empty($settings['team_text'])){     	
	                                    	echo '<span class="thumb icon"><span>'. wp_kses_post( $settings['team_text'] ).'</span></span></span>';
	                                    }	
	                                if(!empty($settings['title2'])){     
	                                	echo '</span>'. wp_kses_post( $settings['title2'] ).'</span></h1>';
	                                }	
	                            if(!empty($settings['summary'])){    
		                        	echo '<p class="hero-text">'. wp_kses_post( $settings['summary'] ).'</p>';
		                        }	
		                        if(!empty($settings['button_text_one'])){
			                        echo ' <div class="btn-group justify-content-center justify-content-xl-start">
			                            <a href="'.esc_url( $settings['button_url_one']['url']  ).'" class="th-btn style1 th-icon">'. wp_kses_post( $settings['button_text_one'] ).'<i class="fa-regular fa-arrow-right ms-2"></i></a>
			                        </div>';
		                        }
		                        if(!empty($settings['image4']['url'])){
			                        echo '<div class="shape jump">';
			                        	echo saor_img_tag( array(
											'url'   => esc_url( $settings['image2']['url']  ),
										));
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		                echo '<div class="col-xl-6">';
		                    echo '<div class="hero2-image">';
		                    	if(!empty($settings['image4']['url'])){
			                        echo '<div class="hero-img" data-mask-src="'.esc_url( $settings['image3']['url']  ).'">';
			                            echo saor_img_tag( array(
											'url'   => esc_url( $settings['image4']['url']  ),
											'class' => 'th-anim'
										));
			                        echo '</div>';
			                    }
			                    if(!empty($settings['image5']['url'])){    
			                        echo '<div class="discount-wrapp">';
			                            echo '<a href="'.esc_url( $settings['image5']['url']) .'" class="play-btn popup-video"><i class="fa-regular fa-play"></i></a>';
			                            if(!empty($settings['summary'])){   	
				                            echo '<div class="discount-tag">';
				                                echo '<span class="discount-anime">'. wp_kses_post( $settings['summary'] ).'</span>';
				                            echo '</div>';
				                        }
			                        echo '</div>';
			                    }    
		                   echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        if(!empty($settings['image6']['url'])){
			        echo '<div class="shape-mockup" data-top="0%" data-left="0%">';
			          	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image6']['url']  ),
						));
			        echo '</div>';
			    }    
		        if(!empty($settings['image7']['url'])){
			        echo '<div class="shape-mockup z-index-3 spin d-none d-md-inline-block" data-top="-4%" data-right="-4%">';
			      		echo saor_img_tag( array(
							'url'   => esc_url( $settings['image7']['url']  ),
						));
			        echo '</div>';
			    }    
		    echo '</div>';
		}elseif($settings['layout_style'] == '3'){

			echo '<div class="th-hero-wrapper  hero-3" id="hero" data-bg-src="'.esc_url( $settings['image1']['url'] ).'">';
		        echo '<div class="container">';
		            echo '<div class="row">';
		                echo '<div class="col-xl-7">';
		                    echo '<div class="hero-style3">';
		                    	if(!empty($settings['subtitle'])){
		                        	echo '<span class="sub-title text-ani-style2">'. wp_kses_post( $settings['subtitle'] ).'</span>';
		                        }	
		                        if(!empty($settings['title'])){
		                        	echo '<h1 class="hero-title text-ani-style3">'. wp_kses_post( $settings['title'] ).'</h1>';
		                        }
		                        if(!empty($settings['summary'])){	
		                        	echo '<p class="hero-text">'. wp_kses_post( $settings['summary'] ).'</p>';
		                        }	
		                        echo '<div class="btn-group">';
		                        	if(!empty($settings['button_text_one'])){
		                            	echo '<a href="'.esc_url( $settings['button_url_one']['url']  ).'" class="th-btn blue-btn style1 th-icon th-radius">'. wp_kses_post( $settings['button_text_one'] ).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
		                            }
		                            if(!empty($settings['button_text_two'])){
		                            	echo '<a href="'.esc_url( $settings['button_url_two']['url']  ).'" class="th-btn th-icon th-radius style1">'. wp_kses_post( $settings['button_text_two'] ).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
		                            }	
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		            if(!empty($settings['image2']['url'])){
			            echo '<div class="hero-img tilt-active">';
			                echo saor_img_tag( array(
								'url'   => esc_url( $settings['image2']['url']  ),
							));
			            echo '</div>';
		            }
		            echo '<div class="th-circle">';
		                echo '<span class="circle style1"></span>';
		                echo '<span class="circle style2"></span>';
		            echo '</div>';
		            if(!empty($settings['image3']['url'])){
			            echo '<div class="hero-shape">';
			                echo saor_img_tag( array(
								'url'   => esc_url( $settings['image3']['url']  ),
							));
			            echo '</div>';
			        }    
		        echo '</div>';
		        if(!empty($settings['image4']['url'])){
			        echo '<div class="shape-mockup z-index-3 movingX d-none d-xl-block" data-top="26%" data-right="9%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image4']['url']  ),
						));
			        echo '</div>';
			    }
			    if(!empty($settings['image5']['url'])){    
			        echo '<div class="shape-mockup movingX d-none d-xxl-block" data-bottom="15%" data-right="35%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image5']['url']  ),
						));
			        echo '</div>';
			    }    
		    echo '</div>';

		}elseif($settings['layout_style'] == '4'){
			echo '<div class="th-hero-wrapper hero-4" id="hero" data-bg-src="'.esc_url( $settings['image1']['url'] ).'">';
		        echo '<div class="container">';
		            echo '<div class="row align-items-center">';
		                echo '<div class="col-xl-8">';
		                    echo '<div class="hero-style4">';
		                    	if(!empty($settings['subtitle'])){
		                        	echo '<span class="sub-title text-ani-style2"><span class="square-text">
		                                <span class="dot1"></span>
		                                <span class="dot2"></span>'. wp_kses_post( $settings['subtitle'] ).'</span></span>';
		                        }
		                        if(!empty($settings['title'])){        
		                        	echo '<h1 class="hero-title text-ani-style3">'. wp_kses_post( $settings['title'] ).'</h1>';
		                        }
		                        
		                        if(!empty($settings['summary'])){	
		                        	echo '<p class="hero-text">'. wp_kses_post( $settings['summary'] ).'</p>';
		                        }	
		                        echo '<div class="btn-group">';

		                            if(!empty($settings['button_text_one'])){
		                            	echo '<a href="'.esc_url( $settings['button_url_one']['url']  ).'" class="th-btn blue-btn th-icon th-radius">'. wp_kses_post( $settings['button_text_one'] ).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
		                            }
		                            if(!empty($settings['button_text_two'])){
		                            	echo '<a href="'.esc_url( $settings['button_url_two']['url']  ).'" class="th-btn th-icon th-radius">'. wp_kses_post( $settings['button_text_two'] ).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
		                            }

		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		                if(!empty( $settings['image2']['url'])){
		                	echo '<div class="col-xl-4">';
			                    echo '<div class="hero-img">';
			                        echo saor_img_tag( array(
										'url'   => esc_url( $settings['image2']['url']  ),
									));
			                    echo '</div>';
			                echo '</div>';
		                }
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		}elseif($settings['layout_style'] == '5'){

			echo '<div class="th-hero-wrapper hero-5" data-bg-src="'.esc_url( $settings['image1']['url'] ).'">';
		        echo '<div class="container">';
		            echo '<div class="row align-items-center">';
		                echo '<div class="col-xl-10">';
		                    echo '<div class="hero-style5">';
		                    	if(!empty($settings['subtitle'])){
		                        	echo '<span class="sub-title"><span class="square-text">';
		                                echo '<span class="dot1"></span>';
		                                echo '<span class="dot2"></span>'. wp_kses_post( $settings['subtitle'] ).'</span></span>';
		                        }
		                        if(!empty($settings['title'])){        
		                        	echo '<h1 class="hero-title">'. wp_kses_post( $settings['title'] ).'</h1>';
		                        }
		                        if(!empty($settings['summary'])){ 	
		                        	echo '<p class="hero-text">'. wp_kses_post( $settings['summary'] ).'</p>';
		                        }
		                        if(!empty($settings['button_text_one'])){ 		
			                        echo '<div class="btn-group justify-content-center justify-content-xl-start">';
			                            echo '<a href="'.esc_url( $settings['button_url_one']['url']  ).'" class="th-btn th-icon th-black3">'. wp_kses_post( $settings['button_text_one'] ).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
			                        echo '</div>';
			                    }    
		                    echo '</div>';
		                echo '</div>';
		           echo ' </div>';
		        echo '</div>';
		        if(!empty($settings['image2']['url'])){ 
			        echo '<div class="hero-img1">';
			            echo '<img src="'.esc_url( $settings['image2']['url'] ).'" alt="'.esc_attr(get_bloginfo('name')).'">';
			            echo '<a href="'.esc_url( $settings['video_url']['url']  ).'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
			        echo '</div>';
			    }
			    if(!empty($settings['image3']['url'])){    
			        echo '<div class="hero-img2">';
			            echo '<img src="'.esc_url( $settings['image3']['url'] ).'" alt="Hero Image">';
			        echo '</div>';
			    }

		        echo '<div class="hero-client">';
		            echo '<div class="client-review">';
			            if(!empty($settings['client_image']['url'])){
			                echo '<div class="icon">';
			                	echo saor_img_tag( array(
									'url'   => esc_url( $settings['client_image']['url'] ),
								));
			                echo '</div>';
			            }
		                if(!empty($settings['satisfy_client'] || $settings['client_title'] )){
		                	echo '<h4 class="number">'. wp_kses_post( $settings['satisfy_client'] ).'</h4><span class="text">'. wp_kses_post( $settings['client_title'] ).'</span>';
		                }	
		            echo '</div>';

		            echo '<div class="client-thumb-group">';
		            	foreach( $settings['client_team_list'] as $data ){
			              	echo '<div class="thumb">';
			              		echo saor_img_tag( array(
									'url'   => esc_url( $data['image']['url'] ),
								));
			              	echo '</div>';
		              	}
		              	if(!empty($settings['client_number'])){
		                	echo '<div class="thumb icon">'. wp_kses_post( $settings['client_number'] ).'<i class="fa-regular fa-plus"></i></div>';
		                }	
		            echo '</div>';

		        echo '</div>';
		        if(!empty($settings['hero_title'])){
			        echo '<div class="hero-title-area">';
			            echo '<h3 class="title">'. wp_kses_post( $settings['hero_title'] ).'</h3>';
			        echo '</div>';
			    }
			    if(!empty($settings['hero_link'])){    
			        echo '<div class="hero-link">';
			            echo wp_kses_post( $settings['hero_link'] );
			        echo '</div>';
			    }
			    if(!empty($settings['image4']['url'])){ 
			        echo '<div class="shape-mockup z-index-3 movingX d-none d-xl-block" data-top="20%" data-right="38%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image4']['url'] ),
						));
			        echo '</div>';
		        }
		        if(!empty($settings['image5']['url'])){ 
			        echo '<div class="shape-mockup movingX d-none d-xxl-block" data-bottom="4%" data-left="34%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image5']['url'] ),
						));
			        echo '</div>';
			    }
 				if(!empty($settings['image6']['url'])){ 
			        echo '<div class="shape-mockup d-none d-xxl-block" data-bottom="0%" data-left="0%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image6']['url'] ),
						));
			        echo '</div>';
			    }
 				if(!empty($settings['image7']['url'])){ 
			        echo '<div class="shape-mockup d-none d-xxl-block" data-bottom="24%" data-left="42%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image7']['url'] ),
						));
			        echo '</div>';
			    }
 				if(!empty($settings['image8']['url'] )){ 
			        echo '<div class="shape-mockup z-index-3 d-none d-xxl-block" data-bottom="18%" data-right="0%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image8']['url'] ),
						));
			        echo '</div>';
			    }    
		    echo '</div>';

		}elseif($settings['layout_style'] == '6'){

			echo '<div class="th-hero-wrapper hero-6">';
		        echo '<div class="swiper th-slider" id="heroSlide6" data-slider-options=\'{"paginationType":"fraction","effect":"fade"}\'>';
		            echo '<div class="swiper-wrapper">';
		            	foreach( $settings['slider_list'] as $data ){
			                echo '<div class="swiper-slide">';
			                    echo '<div class="hero-inner">';
			                        echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['shape']['url'] ).'">';
			                            echo saor_img_tag( array(
											'url'   => esc_url( $data['image']['url'] ),
										));
				                        echo '</div>';
			                        echo '<div class="container">';
			                            echo '<div class="row align-items-center">';
			                                echo '<div class="col-xl-8">';
			                                    echo '<div class="hero-style6">';
			                                    	if(!empty($data['subtitle'])){   
			                                        	echo '<span class="hero-subtitle" data-ani="slideindown" data-ani-delay="0.1s">'. wp_kses_post( $data['subtitle'] ).'</span>';
			                                        }
			                                        if(!empty($data['title'])){   	
			                                        	echo '<h1 class="hero-title" data-ani="slideinleft" data-ani-delay="0.4s">'. wp_kses_post( $data['title'] ).'</h1>';
			                                        }
			                                        if(!empty($data['summary'])){ 	
			                                        	echo '<p class="hero-text" data-ani="slideinleft" data-ani-delay="0.4s">'. wp_kses_post( $data['summary'] ).'</p>';
			                                        }
			                                        if(!empty($data['button_text'])){ 	
				                                        echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.8s">';
				                                            echo '<a href="'.esc_url( $data['button_url']['url']  ).'" class="th-btn style1 th-radius3 th-icon">'. wp_kses_post( $data['button_text'] ).'
				                                                <i class="fa-regular fa-arrow-right ms-2"></i></a>';
				                                        echo '</div>';
				                                    }    
			                                    echo '</div>';
			                                echo ' </div>';
			                                if(!empty($data['video_url']['url'])){
				                                echo '<div class="col-xl-4">';
				                                   echo ' <div class="hero-icon">';
				                                        echo '<a href="'.esc_url( $data['video_url']['url']  ).'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
				                                    echo '</div>';
				                                echo '</div>';
			                                }	
			                            echo '</div>';

			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
		                }
		            echo '</div>';
		            echo '<div class="slider-controller">';
		               echo ' <div class="slider-pagination2" data-slider-id="#heroSlide6"></div>';
		            echo '</div>';
		        echo '</div>';
		        if(!empty($settings['social'])){ 	
			        echo '<div class="th-social">';
			            echo wp_kses_post( $settings['social'] );
			        echo '</div>';
			    }
			    if(!empty($settings['shape1']['url'])){
			        echo '<div class="shape-mockup z-index-3 jump d-none d-xxl-block" data-bottom="10%" data-left="6%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['shape1']['url'] ),
						));
			        echo '</div>';
			    } 
			    if(!empty($settings['shape2']['url'])){   
			        echo '<div class="shape-mockup z-index-3 movingX d-none d-xxl-block" data-bottom="14%" data-left="10%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['shape2']['url'] ),
						));
			        echo '</div>';
			    } 
			    if(!empty($settings['shape3']['url'])){     
			        echo '<div class="shape-mockup z-index-3 d-none d-xxl-block" data-bottom="10%" data-left="50%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['shape3']['url'] ),
						));
			        echo '</div>';
			    } 
			    if(!empty($settings['shape4']['url'])){   
			        echo '<div class="shape-mockup z-index-3 d-none d-xxl-block" data-bottom="18%" data-right="17%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['shape4']['url'] ),
						));
			        echo '</div>';
			    }    
		    echo '</div>';

		}elseif($settings['layout_style'] == '7'){

			echo '<div class="th-hero-wrapper hero-7 bg-top-center" id="hero" data-bg-src="'.esc_url( $settings['image1']['url'] ).'">';
		        echo '<div class="container th-container">';
		            echo '<div class="row gy-4 align-items-center">';
		                echo '<div class="col-xl-8">';
		                    echo '<div class="hero-style7">';
		                    	if(!empty($settings['subtitle'])){ 
		                        	echo '<span class="hero-subtitle">'. wp_kses_post( $settings['subtitle'] ).'</span>';
		                        }
		                        if(!empty($settings['title'])){ 	
		                        	echo '<h1 class="hero-title">'. wp_kses_post( $settings['title'] ).'</h1>';
		                        }
		                        if(!empty($settings['summary'])){ 		
		                        	echo '<p class="hero-text">'. wp_kses_post( $settings['summary'] ).'</p>';
		                        }	
		                    echo '</div>';
		                echo '</div>';
		                echo '<div class="col-xl-4">';
		                    echo '<div class="client-box2">';
		                    	if(!empty($settings['client_title'])){ 
		                        	echo '<h4 class="box-title">'. wp_kses_post( $settings['client_title'] ).'</span></h4>';
		                        }
		                        if(!empty($settings['client_team_list'])){ 		
			                        echo '<div class="client-thumb-group2">';
			                        	foreach( $settings['client_team_list'] as $data ){
				                            echo '<div class="thumb">';
				                           	 	echo saor_img_tag( array(
													'url'   => esc_url( $data['image']['url'] ),
												));
				                            echo '</div>';
				                        }    
			                            echo '<div class="thumb icon"><i class="fa-regular fa-plus"></i></div>';
			                        echo '</div>';
			                    }
			                    if(!empty($settings['image2']['url'] )){     
			                        echo '<div class="shape">';
			                        	echo saor_img_tag( array(
											'url'   => esc_url( $settings['image2']['url'] ),
										));
			                        echo '</div>';
			                    }    
		                   echo ' </div>';
		                echo '</div>';
		            echo '</div>';
		            echo '<div class="row gy-4">';
		                echo '<div class="col-12">';
		                    echo '<div class="hero-image">';

		                        echo '<div class="img1">';
	                      			echo saor_img_tag( array(
										'url'   => esc_url( $settings['image3']['url'] ),
									));
		                        echo '</div>';

		                        echo '<div class="discount-wrapp">';

		                            echo '<a href="#about-sec" class="scroll-wrap"><span>';
		                            	echo saor_img_tag( array(
											'url'   => esc_url( $settings['image4']['url'] ),
										));
		                            echo '</span></a>';

		                            echo '<div class="discount-img spin">';
		                                echo saor_img_tag( array(
											'url'   => esc_url( $settings['image5']['url'] ),
										));
		                            echo '</div>';

		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        if(!empty($settings['social'])){ 
			        echo '<div class="hero-social">';
			            echo wp_kses_post( $settings['social'] );
			        echo '</div>';
		        }	
		        if(!empty($settings['image6']['url'])){  
			        echo '<div class="shape-mockup z-index-3 movingX d-none d-xxl-block" data-top="12%" data-left="0%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image6']['url'] ),
						));
			        echo '</div>';
		        }
		        if(!empty($settings['image7']['url'])){  
			        echo '<div class="shape-mockup z-index-3 movingX d-none d-xxl-block" data-top="15%" data-right="15%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image7']['url'] ),
						));
			        echo '</div>';
			    }    
		        if(!empty($settings['image8']['url'])){    
			        echo '<div class="shape-mockup z-index-3 spin d-none d-xxl-block" data-top="35%" data-right="40%">';
			        	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image8']['url'] ),
						));	
			        echo '</div>';
			    }    
		    echo '</div>';

		}

		
	}

} 