<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Service Widget .
 *
 */
class saor_Service extends Widget_Base {

	public function get_name() {
		return 'saorservice';
	}
	public function get_title() {
		return __( 'Services', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Services', 'saor' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Service Two','Service Three','Service Four','Style Five','Style Six','Style Seven','Style Eight'] );

		$repeater = new Repeater();

		saor_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Title');
		saor_general_fields($repeater, 'subtitle', 'Subtitle', 'TEXTAREA', 'Subtitle'); 
		saor_url_fields($repeater, 'url', 'URL');
		saor_media_fields( $repeater, 'image', 'Image');
		saor_general_fields($repeater, 'arrow_icon', 'Icon', 'TEXT', '<i class="fa-regular fa-arrow-right-long"></i>');

		$this->add_control(
			'service_list',
			[
				'label' 		=> __( 'Service Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Service List', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1','7']
				]
			]
		);

		$service_list2 = new Repeater();

		saor_general_fields($service_list2, 'title', 'Title', 'TEXTAREA2', 'Title');
		$service_list2->add_control(
		    'title_icon',
		    [
		        'label' => esc_html__('Title Icon', 'agrofa-addon'),
		        'type' => \Elementor\Controls_Manager::MEDIA,
		        'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .accordion-item2 .box-title:before' => 'background-image:url({{URL}});',
		        ]
		    ]
		);
		saor_general_fields($service_list2, 'content', 'Content', 'TEXTAREA', 'Content'); 
		saor_url_fields($service_list2, 'url', 'URL');
		saor_media_fields( $service_list2, 'image', 'Image');
		saor_general_fields($service_list2, 'button_text', 'Button Text', 'TEXT', 'Button Text');
		saor_url_fields($service_list2, 'button_url', 'Button URL');

		$this->add_control(
			'service_list2',
			[
				'label' 		=> __( 'Service List', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $service_list2->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Service', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

		$repeater = new Repeater();

		saor_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Title');
		saor_general_fields($repeater, 'subtitle', 'Subtitle', 'TEXTAREA', 'Subtitle'); 
		saor_url_fields($repeater, 'url', 'URL');
		saor_media_fields( $repeater, 'image', 'Image');
		saor_media_fields( $repeater, 'icon', 'Icon Image');
		saor_general_fields($repeater, 'arrow_icon', 'Icon', 'TEXT', '<i class="fa-regular fa-arrow-up-right"></i>');

		$this->add_control(
			'service_list3',
			[
				'label' 		=> __( 'Service Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Service List', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['3']
				]
			]
		);



		$repeater = new Repeater();

		saor_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Title');
		saor_general_fields($repeater, 'subtitle', 'Subtitle', 'TEXTAREA', 'Subtitle'); 
		saor_url_fields($repeater, 'url', 'URL');
		saor_media_fields( $repeater, 'image', 'Image');
		saor_media_fields( $repeater, 'shape', 'Shape Image');

		$this->add_control(
			'service_list4',
			[
				'label' 		=> __( 'Service Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Service List', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['4']
				]
			]
		);


        $service_list5 = new Repeater();

		saor_general_fields($service_list5, 'title', 'Title', 'TEXTAREA2', 'Title');
		saor_general_fields($service_list5, 'subtitle', 'Subtitle', 'TEXTAREA', 'Subtitle'); 
		saor_media_fields( $service_list5, 'image', 'Image');

		$this->add_control(
			'service_list5',
			[
				'label' 		=> __( 'Service Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $service_list5->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Service Title', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['5']
				]
			]
		);


		  $service_list6 = new Repeater();

        saor_general_fields($service_list6, 'number', 'Number', 'TEXTAREA2', '01');
		saor_general_fields($service_list6, 'title', 'Title', 'TEXTAREA2', 'Title');
		saor_general_fields($service_list6, 'subtitle', 'Subtitle', 'TEXTAREA', 'Subtitle'); 
		$service_list6->add_control(
		    'image',
		    [
		        'label' => esc_html__('Image Three', 'agrofa-addon'),
		        'type' => \Elementor\Controls_Manager::MEDIA,
		        'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .service-box:before' => 'background-image:url({{URL}});',
		        ]
		    ]
		); 
		saor_general_fields($service_list6, 'button_text', 'Button Text', 'TEXT', 'Button Text');
		saor_url_fields($service_list6, 'button_url', 'Button URL');

		$this->add_control(
			'service_list6',
			[
				'label' 		=> __( 'Service Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $service_list6->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Service Title', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['6']
				]
			]
		);

		$this->add_control(
		    'shape_img_1',
		    [
		        'label' => esc_html__('Shape Image One', 'agrofa-addon'),
		        'type' => \Elementor\Controls_Manager::MEDIA,
		        'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .service-box:nth-child(1):after,{{WRAPPER}} .service-box:nth-child(2):after' => 'background-image:url({{URL}});',
		        ],
		        'condition'	=> [
					'layout_style' => ['6']
				]
		    ]
		); 


		$service_list8 = new Repeater();

		saor_general_fields($service_list8, 'title', 'Title', 'TEXTAREA2', 'Title');
		saor_general_fields($service_list8, 'subtitle', 'Subtitle', 'TEXTAREA', 'Subtitle');
		saor_media_fields( $service_list8, 'icon_image', 'Icon Image');
		saor_general_fields($service_list8, 'button_title', 'Button Title', 'TEXTAREA2', 'Button Title');
		saor_url_fields($service_list8, 'url', 'URL');
		saor_media_fields( $service_list8, 'button_image', 'Button Image');

		$this->add_control(
			'service_list8',
			[
				'label' 		=> __( 'Service Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $service_list8->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Service Title', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['8']
				]
			]
		);

        $this->end_controls_section();

        saor_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .box-title a,{{WRAPPER}} .box-title,{{WRAPPER}} .service-process_title'  );
        saor_common_style_fields( $this, 'subtitle', 'Sub-Title', '{{WRAPPER}} .box-text,{{WRAPPER}} .according-img-tab .text,{{WRAPPER}} .service-process_text' );

        //---------------------------------------
			//Style Section Start
		//---------------------------------------


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

	        echo '<div class="service-accordion">';
	            echo '<div class="row">';
	                echo '<div class="col-lg-5">';
	                   echo '<div class="service-accordion-content" id="serviceAccordion">';
	                   	$counter = 1;
	                   	
                        foreach( $settings['service_list'] as $data ){	
                        	if($counter == '1'){
								$class = "show";
							}else{
								$class = "";
							}
							if($counter > 1){
								$collpase_class = "collapsed";
							}else{
								$collpase_class = "";
							}
	                        echo '<div class="accordion-item">';
	                            echo '<div class="accordion-header" id="collapse-item-'.esc_attr($counter).'">';
	                                echo '<div class="accordion-button '.esc_attr($collpase_class).'" role="button" data-bs-toggle="collapse" data-bs-target="#collapse-'.esc_attr($counter).'" aria-expanded="true" aria-controls="collapse-'.esc_attr($counter).'">';
	                                    echo '<span class="accordion-item_info">';
	                                        echo '<span class="accordion-item_wrapp">';
	                                            echo '<span class="box-title">'.esc_html($data['title']).'</span>';
	                                        echo '</span>';
	                                        echo '<span class="icon">'.wp_kses_post($data['arrow_icon']).'</span>';
	                                    echo '</span>';
	                                echo '</div>';
	                            echo '</div>';
	                           echo ' <div id="collapse-'.esc_attr($counter).'" class="accordion-collapse collapse '.esc_attr($class).'" aria-labelledby="collapse-item-'.esc_attr($counter).'" data-bs-parent="#serviceAccordion">';
	                                echo '<div class="accordion-body">';
	                                    echo '<p class="faq-text">'.esc_html($data['subtitle']).'</p>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    $counter++;
                        }     
	                    echo '</div>';
	                echo '</div>';
	                echo '<div class="col-lg-7">';
	                    echo '<div class="th-accordion_images">';
						$counter = 1;
		                   	
                        foreach( $settings['service_list'] as $data ){	
                        	if($counter == '1'){
								$class = "active";
							}else{
								$class = "";
							}
	                        echo '<img class="'.esc_attr($class).'" src="'.esc_url( $data['image']['url'] ).'" alt="'.get_bloginfo('name').'">';
	                        $counter++;
                        }    
	                   echo '</div>';
	                echo '</div>';
	           echo ' </div>';
	        echo '</div>';

		}elseif( $settings['layout_style'] == '2'){ 

			echo '<div class="according-list-area">';
				foreach( $settings['service_list2'] as $data ){ 
		            echo '<div class="according-list hover-item item-active">';
		                echo '<div class="accordion-item2">';
		                    echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
		                echo '</div>';
		                echo '<div class="according-img">';
		                    echo saor_img_tag( array(
								'url'   => esc_url( $data['image']['url'] ),
							));
		                    echo '<p class="text">'.esc_html($data['content']).'</p>';
		                    if(!empty($data['button_text'])):
		                    	echo '<div class="sec-btn">';
			                        echo '<a href="'.esc_url($data['button_url']['url']).'" class="th-btn ser-btn th-icon">'.esc_html($data['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i> </a>';
			                    echo '</div>';
			                endif;    
		                echo '</div>';
		            echo '</div>';
	            }
	        echo '</div>';

		}elseif($settings['layout_style'] == '3'){

			echo '<div class="row gy-4">';
				$counter = '1';
                foreach( $settings['service_list3'] as $data ){
	                echo '<div class="service-card tg-img-reveal-item" data-fx="1" data-img="'.esc_url( $data['image']['url'] ).'" style="">';
	                    echo '<div class="service-wrapp">';
	                        echo '<div class="box-icon">';
	                            echo saor_img_tag( array(
									'url'   => esc_url( $data['icon']['url'] ),
								));
	                        echo '</div>';
	                        if(!empty($data['title'])):
	                        	echo '<h3 class="box-title"><a href="'.esc_url($data['url']['url']).'">'.wp_kses_post($data['title']).'</a></h3>';
	                        endif;	
	                    echo '</div>';
	                    echo '<div class="service-content">';
	                    	if(!empty($data['subtitle'])):
	                        	echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
	                        endif;
 							if(!empty($data['url']['url'])):
	                        	echo '<div class="icon-btn"><a href="'.esc_url($data['url']['url']).'">'.wp_kses_post($data['arrow_icon']).'</a></div>';
	                        endif;	
	                    echo '</div>';
	                echo '</div>';
                }
            echo '</div>';
            
		}elseif($settings['layout_style'] == '4'){

			echo '<div class="service-grid_wrapp">';
				$counter = '1';
                foreach( $settings['service_list4'] as $data ){
	                if($counter == '3'){
						$class = "item-active";
					}else{
						$class = "";
					}
	                echo '<div class="service-grid hover-item '.esc_attr($class).'">';
	                	if(!empty($data['image']['url'])):
		                    echo '<div class="box-icon">';
		                        echo saor_img_tag( array(
									'url'   => esc_url( $data['image']['url'] ),
								));
		                    echo '</div>';
		                endif;    
	                    echo '<div class="service-grid_content">';
	                    	if(!empty($data['title'])):
	                        	echo ' <h3 class="box-title"><a href="'.esc_url($data['url']['url']).'">'.wp_kses_post($data['title']).'</a></h3>';
	                        endif;
	                        if(!empty($data['subtitle'])):	
	                        	echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
	                        endif;	
	                    echo '</div>';
	                    if(!empty($data['shape']['url'])):
		                    echo '<div class="ser-shape">';
		                    	echo saor_img_tag( array(
									'url'   => esc_url( $data['shape']['url'] ),
								));
		                    echo '</div>';
		                endif;
	                echo '</div>';
	                $counter++;
                }
            echo ' </div>';

		}elseif($settings['layout_style'] == '5'){

			echo '<div class="service-process-wrap">';
				foreach( $settings['service_list5'] as $data ){
	                echo '<div class="service-process">';
	                    echo '<div class="service-process_img">';
	                    	echo saor_img_tag( array(
								'url'   => esc_url( $data['image']['url'] ),
							));
	                    echo '</div>';
	                    echo '<div class="service-process_centent">';
	                    	if(!empty($data['title'])):
	                        	echo '<h5 class="service-process_title">'.wp_kses_post($data['title']).'</h5>';
	                        endif;
	                        if(!empty($data['subtitle'])):	
	                        	echo '<p class="service-process_text">'.wp_kses_post($data['subtitle']).'</p>';
	                        endif;	
	                    echo '</div>';
	                echo '</div>';
                }
            echo '</div>';

        }elseif($settings['layout_style'] == '6'){   

        	echo '<div class="service-box_wrapp">';
        		$counter = 1;
        		foreach( $settings['service_list6'] as $data ){
        			if($counter < '3'){
        				echo '<div class="service-box">';
		                    echo '<div class="service-overlay"></div>';
		                    if(!empty($data['number'])){
		                    	echo '<div class="box-number">'.wp_kses_post($data['number']).'</div>';
		                    }
		                    echo '<div class="service-content">';
		                    	if(!empty($data['title'])){
			                        echo '<h3 class="box-title"><a href="'.esc_url($data['button_url']['url']).'">'.wp_kses_post($data['title']).'</a></h3>';
			                    }
			                    if(!empty($data['subtitle'])){
			                        echo '<p class="box-text">'.wp_kses_post($data['subtitle']).'</p>';
			                    }
			                    if(!empty($data['button_text'])){
		                        	echo '<a href="'.esc_url($data['button_url']['url']).'" class="line-btn">'.wp_kses_post($data['button_text']).' <i class="fa-solid fa-arrow-right ms-2"></i></a>';
		                        }
		                   echo ' </div>';
		                echo '</div>';
        			}
	                
	                $counter++;

                }	
            echo '</div>';
            echo '<div class="service-box_wrapp">';

                $counter = 1;
        		foreach( $settings['service_list6'] as $data ){
        			if($counter > '2'){
        				echo '<div class="service-box">';
		                    echo '<div class="service-overlay"></div>';
		                    if(!empty($data['number'])){
		                    	echo '<div class="box-number">'.wp_kses_post($data['number']).'</div>';
		                    }
		                    echo '<div class="service-content">';
		                    	if(!empty($data['title'])){
			                        echo '<h3 class="box-title"><a href="'.esc_url($data['button_url']['url']).'">'.wp_kses_post($data['title']).'</a></h3>';
			                    }
			                    if(!empty($data['subtitle'])){
			                        echo '<p class="box-text">'.wp_kses_post($data['subtitle']).'</p>';
			                    }
			                    if(!empty($data['button_text'])){
		                        	echo '<a href="'.esc_url($data['button_url']['url']).'" class="line-btn">'.wp_kses_post($data['button_text']).' <i class="fa-solid fa-arrow-right ms-2"></i></a>';
		                        }
		                   echo ' </div>';
		                echo '</div>';
        			}
	                
	                $counter++;
                }	
                
            echo '</div>';

        }elseif($settings['layout_style'] == '7'){ 

        	echo '<div class="ps-xl-5">';
        		foreach( $settings['service_list'] as $data ){
	                echo '<div class="service-item">';
	                    echo '<div class="service-wrapp">';
	                        echo '<span class="box-icon">';
	                        	echo saor_img_tag( array(
									'url'   => esc_url( $data['image']['url'] ),
								));
	                        echo '</span>';
	                        echo '<div class="box-content">';
	                        	if(!empty($data['title'])){
	                            	echo '<h3 class="box-title"><a href="'.esc_url($data['url']['url']).'">'.esc_html($data['title']).'</a> </h3>';
	                            }
	                            if(!empty($data['subtitle'])){
	                            	echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
	                            }
	                        echo '</div>';
	                    echo '</div>';
	                    if(!empty($data['arrow_icon'])){
	                   	 	echo '<div class="icon-btn">'.wp_kses_post($data['arrow_icon']).'</div>';
	                   	}
	                echo '</div>';
               	}
            echo '</div>';

        }elseif($settings['layout_style'] == '8'){ 

        	echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="serviceSlider7" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"1199":{"slidesPerView":"3"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                    	foreach( $settings['service_list8'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="service-grid2">';
	                                echo '<div class="box-icon">';
	                                    echo saor_img_tag( array(
											'url'   => esc_url( $data['icon_image']['url'] ),
										));
	                                echo '</div>';
	                                echo '<div class="box-content">';
	                                    if(!empty($data['title'])){
			                            	echo '<h3 class="box-title"><a href="'.esc_url($data['url']['url']).'">'.esc_html($data['title']).'</a> </h3>';
			                            }
			                            if(!empty($data['subtitle'])){
			                            	echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
			                            }
			                            if(!empty($data['button_title'])){
		                                    echo '<a href="'.esc_url($data['url']['url']).'" class="line-btn">';
		                                    	echo esc_html($data['button_title']);
		                                     	echo saor_img_tag( array(
													'url'   => esc_url( $data['button_image']['url'] ),
												));
		                                    echo '</a>';
		                                }    
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
                        }
                    echo '</div>';
                echo '</div>';
                echo '<button data-slider-prev="#serviceSlider7" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#serviceSlider7" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

		}


	}

}