<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
/**
 *
 * Section Title Widget .
 *
 */
class Saor_Section_Title extends Widget_Base {

	public function get_name() {
		return 'saorsectiontitle';
	}
	public function get_title() {
		return __( 'Section Title', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Section Title', 'saor' ), 
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three' ] );

		$this->add_control(
			'shape',
			[
				'label' 		=> __( 'Upload Shape if Change', 'saor' ),
				'type' 			=> Controls_Manager::MEDIA,
				'condition'		=> [ 
					'layout_style' => ['2', '3' ],
				],
			]
		);
		
		saor_general_fields( $this, 'section_subtitle', 'Subtitle', 'TEXT', 'Subtitle' );
		saor_general_fields( $this, 'section_shadow_title', 'Shadow Title', 'TEXT', 'Shadow Title' );
		saor_general_fields( $this, 'section_title', 'Title', 'TEXTAREA', 'Title Here' );
		saor_general_fields( $this, 'section_icon', 'Icon', 'TEXT', '<i class="text-theme far fa-heart"></i>','2' );
		
        $this->add_control(
			'section_title_tag', 
			[
				'label' 	=> __( 'Title Tag', 'saor' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'span'  => 'span',
				],
				'default' => 'h2',
			]
        );

		saor_general_fields( $this, 'section_desc', 'Description', 'TEXTAREA', '' );

        $this->add_responsive_control(
			'section_align',
			[
				'label' 		=> __( 'Alignment', 'saor' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __( 'Left', 'saor' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'saor' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'saor' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 	=> '',
				'toggle' 	=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .title-area' => 'text-align: {{VALUE}};',
                ]
			]
		);

		saor_general_fields( $this, 'wrap_class', 'Wraper Extra Class', 'TEXT', '' );
		saor_general_fields( $this, 'section_subtitle_class', 'Subtitle Extra Class', 'TEXT', '' );
		saor_general_fields( $this, 'section_title_class', 'Title Extra Class', 'TEXT', '' );
		saor_general_fields( $this, 'section_shadow_title_class', 'Shadow Title Extra Class', 'TEXT', '' );
		saor_general_fields( $this, 'section_desc_class', 'Description Class', 'TEXT', '' );

		$this->add_control(
		    'subtitle_before_shape',
		    [
		        'label' => esc_html__('Subtitle Shape', 'agrofa-addon'),
		        'type' => \Elementor\Controls_Manager::MEDIA,
		        'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .sub-title.sub-title2:before,{{WRAPPER}} .sub-title.sub-title2:after,{{WRAPPER}} .sub-title.sub-title3:before,{{WRAPPER}} .sub-title.sub-title3:after,{{WRAPPER}} .sub-title.sub-title4,{{WRAPPER}} .sub-title.sub-title4 span,{{WRAPPER}} .sub-title.sub-title5,{{WRAPPER}} .sub-title.sub-title6:before,{{WRAPPER}}  .sub-title.sub-title6:after,{{WRAPPER}} .sub-title.sub-title7:before,{{WRAPPER}} .sub-title.sub-title8:before,{{WRAPPER}} .sub-title.sub-title8:after,{{WRAPPER}} .sub-title.sub-title9:before,{{WRAPPER}} .sub-title.sub-title10:before' => 'background-image:url({{URL}});',
		        ],
		        'condition' => [
					'layout_style' => ['1','2','3']
				]
		    ]
		);

		$this->add_control(
		    'subtitle_after_shape',
		    [
		        'label' => esc_html__('After Shape', 'agrofa-addon'),
		        'type' => \Elementor\Controls_Manager::MEDIA,
		        'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .sub-title.sub-title7:after,{{WRAPPER}} .sub-title.sub-title9:after' => 'background-image:url({{URL}});',
		        ],
		        'condition' => [
					'layout_style' => ['1','2','3']
				]
		    ]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------General Style-----------------------//
        $this->start_controls_section(
			'general_style_section',
			[
				'label' => __( 'General Style', 'saor' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		saor_dimensions_fields($this, 'menu_margin', 'Margin', 'margin', '{{WRAPPER}} .title-area');

		$this->end_controls_section();

		//-------Subtitle Style-------
		saor_common_style_fields($this, 'subtitle', 'Subtitle', '{{WRAPPER}} .sub-title,{{WRAPPER}} .sub-title.sub-title7.style1', ['1', '2', '3']);
		//-------Title Style-------
		saor_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} .sec-title');
		//------- Shodow Title Style-------
		saor_common_style_fields($this, 'shadow_title', 'Shadow Title', '{{WRAPPER}} .shadow-title');
		//-------Description Style-------
		saor_common_style_fields($this, 'desc', 'Description', '{{WRAPPER}} p');

	}

	protected function render() {

	$settings = $this->get_settings_for_display();

	if (isset($settings['section_align'])) {
		if ($settings['section_align'] == 'left') {
			$wrap_align_class = 'text-left';
		} elseif ($settings['section_align'] == 'center') {
			$wrap_align_class = 'text-center';
		} elseif ($settings['section_align'] == 'right') {
			$wrap_align_class = 'text-right';
		} else {
			$wrap_align_class = '';
		}
	} else {
		// Default value if 'section_align' is not set
		$wrap_align_class = 'text-left';
	}

	if( $settings['layout_style'] == '2' ){
		$this->add_render_attribute( 'subtitle_args', 'class', 'sub-title2 '. $settings['section_subtitle_class'] );
	}else{
		$this->add_render_attribute( 'subtitle_args', 'class', 'sub-title '. $settings['section_subtitle_class'] );
	}
	$this->add_render_attribute( 'title_args', 'class', 'sec-title '. $settings['section_title_class']  );

	?>
		<div class="title-area <?php echo esc_attr($wrap_align_class . ' ' . $settings['wrap_class']); ?>">
			<?php	
				if ( !empty($settings['section_subtitle' ]) ){
					echo '<span '.$this->get_render_attribute_string( 'subtitle_args' ).'>';
						if( $settings['layout_style'] == '3' ){
							echo '<span class="line"></span>';
						}
						if( $settings['layout_style'] == '2' ){
							echo wp_kses_post( $settings['section_icon' ] );
						}
						echo wp_kses_post( $settings['section_subtitle' ] );
					echo '</span>';
				}

				if( ! empty( $settings['section_shadow_title'] ) ){
					echo saor_paragraph_tag( array(
						'text'	=> wp_kses_post( $settings['section_shadow_title'] ),
						'class'	=> esc_attr($settings['section_shadow_title_class']),
					) );
				}
			
				if ( !empty($settings['section_title' ]) ){
					printf( '<%1$s %2$s>%3$s</%1$s>',
					$settings['section_title_tag'],
					$this->get_render_attribute_string( 'title_args' ),
					wp_kses_post( $settings['section_title' ] )
					);
				}

				if( ! empty( $settings['section_desc'] ) ){
					echo saor_paragraph_tag( array(
						'text'	=> wp_kses_post( $settings['section_desc'] ),
						'class'	=> esc_attr($settings['section_desc_class']),
					) );
				}

			?>
		</div>

	<?php
		
	}
}