<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * process Widget .
 *
 */
class Saor_Process extends Widget_Base {

	public function get_name() {
		return 'saorprocess';
	}
	public function get_title() {
		return __( 'process', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Process', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three' ] );

		$process_list = new Repeater();

        saor_general_fields($process_list, 'title', 'Title', 'TEXTAREA2', 'Default Title');
        saor_general_fields($process_list, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Default Subtitle');
        saor_general_fields($process_list, 'number', 'Number', 'TEXTAREA2', '03');

         $this->add_control(
            'process_list',
            [
                'label'         => __( 'Process List', 'saor' ),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $process_list->get_controls(),
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout_style' => ['1']
                ]
            ]
        );

        $process_list3 = new Repeater();

        saor_general_fields($process_list3, 'title', 'Title', 'TEXTAREA2', 'Default Title');
        saor_general_fields($process_list3, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Default Subtitle');

         $this->add_control(
            'process_list3',
            [
                'label'         => __( 'Process List', 'saor' ),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $process_list3->get_controls(),
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout_style' => ['3']
                ]
            ]
        );

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
        //-------Title Style-------
        saor_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .title' );
        //------Button Style (gradient-color)-------
        saor_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th_btn' );


	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){


            foreach( $settings['process_list'] as $key => $data ){

	            echo '<div class="process-item">';
	            	if(!empty($data['number'])):
		                echo '<span class="box-number">'.esc_html($data['number']).'</span>';
		            endif;
	                echo '<div class="box-content">';
	                	if(!empty($data['title'])):
	                    	echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
	                    endif;
	                    if(!empty($data['subtitle'])):	
	                    	echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
	                    endif;	
	                echo '</div>';
	            echo '</div>';

            }

		}elseif($settings['layout_style'] == '2'){

			echo '<div class="step-wrap">';
               echo ' <div class="process-card_wrapp">';
               		foreach( $settings['process_list2'] as $key => $data ){
	                    echo '<div class="process-card">';
	                        echo '<div class="box-wrapp">';
	                        	if(!empty($data['icon_image']['url'] )):
		                            echo '<div class="box-icon">';
		                                echo saor_img_tag( array(
											'url'   => esc_url( $data['icon_image']['url']  ),
										));
		                            echo '</div>';
		                        endif;
		                        if(!empty($data['arrow_icon_image']['url'] )):
		                            echo '<div class="box-shape">';
		                            	echo saor_img_tag( array(
											'url'   => esc_url( $data['arrow_icon_image']['url']  ),
										));
		                            echo '</div>';
		                        endif;
		                        if(!empty($data['number'])):	
	                            	echo '<div class="box-number">'.esc_html($data['number']).' </div>';
	                            endif;	
	                        echo '</div>';
	                        echo '<div class="box-content">';
	                        	if(!empty($data['title'])):
	                            	echo '<h2 class="box-title">'.esc_html($data['title']).'</h2>';
	                            endif;
	                            if(!empty($data['subtitle'])):	
	                            	echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
	                            endif;	
	                        echo '</div>';
	                    echo '</div>';
                    }
                echo '</div>';
            echo '</div>';

        }elseif($settings['layout_style'] == '3'){

            echo '<div class="timeline">';
            	$counter = 1;
            	foreach( $settings['process_list3'] as $key => $data ){
            		if ($counter % 2 == 0){
            			$class = "right";
            		}else{
            			$class = "left";
            		}
	                echo '<div class="containr '.esc_attr($class).'-container">';
	                    echo '<div class="timeline-step">';
	                    	if(!empty($data['title'])):
	                        	echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
	                        endif;
	                        if(!empty($data['subtitle'])):	
	                        	echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
	                        endif;	
	                    echo '</div>';
	                echo '</div>';
	                $counter++;
               	}
            echo '</div>';

		}

	
	}

}