<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Price Widget .
 *
 */
class Saor_Price extends Widget_Base {

	public function get_name() {
		return 'saorprice';
	}
	public function get_title() {
		return __( 'Price Box', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'price_section',
			[
				'label' 	=> __( 'Price Box', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two','Style Three','Style Four' ] );


		saor_general_fields($this, 'sec_title', 'Section Title', 'TEXTAREA', 'Section Title');
		saor_general_fields($this, 'sec_shadow_title', 'Section Shadow Title', 'TEXTAREA', 'Section Shadow Title',['2']);
		$this->add_control(
		    'subtitle_before_shape',
		    [
		        'label' => esc_html__('Subtitle Shape', 'agrofa-addon'),
		        'type' => \Elementor\Controls_Manager::MEDIA,
		        'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .sub-title.sub-title2:before,{{WRAPPER}} .sub-title.sub-title2:after,{{WRAPPER}} .sub-title.sub-title3:before,{{WRAPPER}} .sub-title.sub-title3:after,{{WRAPPER}} .sub-title.sub-title4,{{WRAPPER}} .sub-title.sub-title4 span,{{WRAPPER}} .sub-title.sub-title5,{{WRAPPER}} .sub-title.sub-title6:before,{{WRAPPER}}  .sub-title.sub-title6:after,{{WRAPPER}} .sub-title.sub-title7:before,{{WRAPPER}} .sub-title.sub-title8:before,{{WRAPPER}} .sub-title.sub-title8:after,{{WRAPPER}} .sub-title.sub-title9:before,{{WRAPPER}} .sub-title.sub-title10:before' => 'background-image:url({{URL}});',
		        ],
		        'condition' => [
					'layout_style' => ['4']
				]
		    ]
		);
		$this->add_control(
		    'subtitle_before_shape',
		    [
		        'label' => esc_html__('Subtitle Shape', 'agrofa-addon'),
		        'type' => \Elementor\Controls_Manager::MEDIA,
		        'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .sub-title.sub-title2:before,{{WRAPPER}} .sub-title.sub-title2:after,{{WRAPPER}} .sub-title.sub-title3:before,{{WRAPPER}} .sub-title.sub-title3:after,{{WRAPPER}} .sub-title.sub-title4,{{WRAPPER}} .sub-title.sub-title4 span,{{WRAPPER}} .sub-title.sub-title5,{{WRAPPER}} .sub-title.sub-title6:before,{{WRAPPER}}  .sub-title.sub-title6:after,{{WRAPPER}} .sub-title.sub-title7:before,{{WRAPPER}} .sub-title.sub-title5 span' => 'background-image:url({{URL}});',
		        ],
		        'condition' => [
					'layout_style' => ['1','3']
				]
		    ]
		);

 

		saor_general_fields($this, 'sec_subtitle', 'Section Sub-Title', 'TEXTAREA', 'Section Sub-Title');
		saor_general_fields($this, 'sec_summary', 'Section Summary', 'TEXTAREA', 'Section Summary');  
		saor_general_fields($this, 'month', 'Month', 'TEXTAREA', 'Month',['1','3','2','4']);  
		saor_general_fields($this, 'year', 'Year', 'TEXTAREA', 'Year',['1','3','2','4']);  

		$repeater = new Repeater();

		saor_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Basic Plan');
		saor_general_fields($repeater, 'subtitle', 'Sub Title', 'TEXTAREA2', 'Subtitle');
		saor_general_fields($repeater, 'price', 'Price', 'TEXTAREA', '$99.00');
		saor_general_fields($repeater, 'month', 'Month', 'TEXTAREA', 'Month');  
		saor_code_fields($repeater, 'features', 'Features', ''); 
		saor_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Get Started');
		saor_url_fields($repeater, 'button_url', 'Button URL');

		$this->add_control(
			'price_lists',
			[
				'label' 		=> __( 'Monthly Price Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Basic Plan', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1','3']
				]
			]
		);

		$price_lists2 = new Repeater();

		saor_general_fields($price_lists2, 'title', 'Title', 'TEXTAREA2', 'Basic Plan');
		saor_general_fields($price_lists2, 'subtitle', 'Sub-Title', 'TEXTAREA2', 'Subtitle');
		saor_general_fields($price_lists2, 'price', 'Price', 'TEXTAREA', '$99.00');
		saor_general_fields($price_lists2, 'month', 'Month', 'TEXTAREA', 'Month');  
		saor_code_fields($price_lists2, 'features', 'Features', ''); 
		saor_general_fields($price_lists2, 'button_text', 'Button Text', 'TEXT', 'Get Started');
		saor_url_fields($price_lists2, 'button_url', 'Button URL');

		$this->add_control(
			'price_lists2',
			[
				'label' 		=> __( 'Yearly Price Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $price_lists2->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Basic Plan', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1','3']
				]
			]
		);

		$price_list3 = new Repeater();

		saor_general_fields($price_list3, 'title', 'Title', 'TEXTAREA2', 'Basic Plan');
		saor_general_fields($price_list3, 'subtitle', 'Sub Title', 'TEXTAREA2', 'Subtitle');
		saor_general_fields($price_list3, 'price', 'Price', 'TEXTAREA', '$99.00');
		saor_general_fields($price_list3, 'month', 'Month', 'TEXTAREA', 'Month');  
		saor_code_fields($price_list3, 'features', 'Features', ''); 
		saor_general_fields($price_list3, 'offer_tag', 'Offer Tag', ''); 
		saor_general_fields($price_list3, 'button_text', 'Button Text', 'TEXT', 'Get Started');
		saor_url_fields($price_list3, 'button_url', 'Button URL');

		$this->add_control(
			'price_list3',
			[
				'label' 		=> __( 'Monthly Price Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $price_list3->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Basic Plan', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2','3','4']
				]
			]
		);

		$price_lists4 = new Repeater();

		saor_general_fields($price_lists4, 'title', 'Title', 'TEXTAREA2', 'Basic Plan');
		saor_general_fields($price_lists4, 'subtitle', 'Sub-Title', 'TEXTAREA2', 'Subtitle');
		saor_general_fields($price_lists4, 'price', 'Price', 'TEXTAREA', '$99.00');
		saor_general_fields($price_lists4, 'month', 'Month', 'TEXTAREA', 'Month');  
		saor_code_fields($price_lists4, 'features', 'Features', ''); 
		saor_general_fields($price_lists4, 'offer_tag', 'Offer Tag', ''); 
		saor_general_fields($price_lists4, 'button_text', 'Button Text', 'TEXT', 'Get Started');
		saor_url_fields($price_lists4, 'button_url', 'Button URL');

		$this->add_control(
			'price_lists4',
			[
				'label' 		=> __( 'Yearly Price Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $price_lists4->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Basic Plan', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2','3','4']
				]
			]
		);

		saor_media_fields( $this, 'image1',  'Choose Image One',['1']);
		saor_media_fields( $this, 'image2', 'Choose Image Two',['1']);
		saor_media_fields( $this, 'image3', 'Choose Image Three',['1']);

		$this->add_control(
		    'subtitle_after_shape',
		    [
		        'label' => esc_html__('After Shape', 'saor-addon'),
		        'type' => \Elementor\Controls_Manager::MEDIA,
		        'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .sub-title.sub-title7:before,{{WRAPPER}} .sub-title.sub-title5 span' => 'background-image:url({{URL}});',
		        ],
		        'condition' => [
					'layout_style' => ['3','1']
				]
		    ]
		);

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Subtitle Style-------
		saor_common_style_fields($this, 'sec_subtitle', 'Section Subtitle', '{{WRAPPER}} .sub-title,{{WRAPPER}} .sub-title.sub-title7.style1');
		//-------Title Style-------
		saor_common_style_fields($this, 'sec_title', 'Section Title', '{{WRAPPER}} .sec-title');

		saor_common_style_fields( $this, '02', 'Title', '{{WRAPPER}} .box-title' );
		saor_common_style_fields( $this, '03', 'Price', '{{WRAPPER}} .box-price' );
		saor_common_style_fields( $this, '04', 'Features', '{{WRAPPER}} .available-list li' );

		//------Button Style-------
		saor_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th-btn' );

	}

	protected function render() {

	$settings = $this->get_settings_for_display();


		if( $settings['layout_style'] == '1' ){
			echo '<section class="space overflow-hidden" data-bg-src="'.esc_url($settings['image1']['url']).'">';
		        echo '<div class="container">';
		            echo '<div class="title-area text-center">';
		            	if(!empty($settings['sec_shadow_title'])){
		                	echo '<div class="shadow-title">'.esc_html($settings['sec_shadow_title']).'</div>';
		               	}
		               	if(!empty($settings['sec_title'])){ 	
		                	echo '<span class="sub-title sub-title5 text-white">'.wp_kses_post($settings['sec_title']).'</span>';
		                }
		                if(!empty($settings['sec_subtitle'])){ 	
		                	echo '<h2 class="sec-title text-white">'.wp_kses_post($settings['sec_subtitle']).'</h2>';
		                }
		                if(!empty($settings['sec_summary'])){ 		
		                	echo '<p class="text-white">'.esc_html($settings['sec_summary']).'</p>';
		                }
		                if(!empty($settings['month'] || $settings['year'])){
			                echo '<div class="pricing-tabs">';
			                    echo '<div class="switch-area">';
			                    	if(!empty($settings['month'])){
			                        	echo '<label class="toggler toggler--is-active ms-0 text-white" id="filt-monthly">'.esc_html($settings['month']).'</label>';
			                        }	
			                        echo '<div class="toggle">';
			                            echo '<input type="checkbox" id="switcher" class="check">';
			                            echo '<b class="b switch"></b>';
			                        echo '</div>';
			                        if(!empty($settings['year'])){
			                        	echo '<label class="toggler text-white" id="filt-yearly">'.esc_html($settings['year']).'</label>';
			                        }	
			                    echo '</div>';
			                echo '</div>';
			            }    
		            echo '</div>';
		            echo '<div id="monthly" class="wrapper-full">';
		                echo '<div class="row gy-4 justify-content-center">';
		                	$counter = 1;
		                	foreach( $settings['price_lists'] as $key => $data ){
		                		if($counter == '2'){
		                			$active_class = "active";
		                		}else{
		                			$active_class = "";
		                		}
		                		
			                    echo '<div class="col-xl-4 col-md-6">';
			                        echo '<div class="price-item th-ani '.esc_attr($active_class).'">';
			                        	if(!empty($data['title'])){
			                        		echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
			                        	}
			                            if(!empty($data['subtitle'])){	
			                            	echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
			                            }
			                            if(!empty($data['price'])){		
			                            	echo '<h4 class="box-price">'.esc_html($data['price']).'<span class="duration">'.esc_html($data['month']).'</span></h4>';
			                            }
			                            echo '<div class="box-content">';
			                            	if(!empty($data['features'])){
				                                echo '<div class="available-list">';
				                                    echo '<ul>';
				                                        echo wp_kses_post($data['features']);
				                                    echo '</ul>';
				                                echo '</div>';
				                            }    
				                            if(!empty($data['button_text'])){	
				                                echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style1 btn-fw">'.wp_kses_post($data['button_text']).'</a>';
				                            }
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                    $counter++;
			                }    
		                echo '</div>';
		            echo '</div>';
		            echo '<div id="yearly" class="wrapper-full hide">';
		                echo ' <div class="row gy-4 justify-content-center">';
		                	$counter = 1;
		                    foreach( $settings['price_lists2'] as $key => $data ){
		                    	if($counter == '2'){
		                			$active_class = "active";
		                		}else{
		                			$active_class = "";
		                		}
			                    echo '<div class="col-xl-4 col-md-6">';
			                        echo '<div class="price-item th-ani '.esc_attr($active_class).'">';
			                        	if(!empty($data['title'])){
			                        		echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
			                        	}
			                            if(!empty($data['subtitle'])){	
			                            	echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
			                            }
			                            if(!empty($data['price'])){		
			                            	echo '<h4 class="box-price">'.esc_html($data['price']).'<span class="duration">'.esc_html($data['month']).'</span></h4>';
			                            }
			                            echo '<div class="box-content">';
			                            	if(!empty($data['features'])){
				                                echo '<div class="available-list">';
				                                    echo '<ul>';
				                                        echo wp_kses_post($data['features']);
				                                    echo '</ul>';
				                                echo '</div>';
				                            }    
				                            if(!empty($data['button_text'])){	
				                                echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style1 btn-fw">'.wp_kses_post($data['button_text']).'</a>';
				                            }
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                     $counter++;
			                }

		                 echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        if(!empty($settings['image2']['url'])){
		        	echo '<div class="shape-mockup" data-top="0%" data-right="0%">';
		       	 		echo saor_img_tag( array(
		                    'url'   => esc_url( $settings['image2']['url'] ),
		                ) );
			        echo '</div>';
		        }

		        if(!empty($settings['image3']['url'])){
		        	echo '<div class="shape-mockup spin" data-bottom="15%" data-left="3%">';
		            	echo saor_img_tag( array(
		                    'url'   => esc_url( $settings['image3']['url'] ),
		                ) );
		            echo '</div>';
		        }

		    echo '</section>';
		    
		}elseif($settings['layout_style'] == '3' ){

			echo '<section class="price-area overflow-hidden space">';
		        echo '<div class="container">';
		            echo '<div class="row justify-content-md-between justify-content-center align-items-end">';
		            	if(!empty($settings['sec_title'] || $settings['sec_subtitle'])){	
			                echo '<div class="col-md-6">';
			                    echo '<div class="title-area text-center text-md-start">';
			                        echo '<span class="sub-title sub-title7 style1 text-ani-style2 text-white">'.esc_html($settings['sec_title']).'</span>';
			                       echo ' <h2 class="sec-title text-ani-style3 text-white">'.esc_html($settings['sec_subtitle']).'</h2>';
			                    echo '</div>';
			                echo '</div>';
			            }
			            if(!empty($settings['month'] || $settings['year'])){	    
			                echo '<div class="col-md-auto">';
			                    echo '<div class="pricing-tabs style3">';
			                        echo '<div class="switch-area">';
			                            echo '<label class="toggler toggler--is-active ms-0" id="filt-monthly">'.esc_html($settings['month']).'</label>';
			                            echo '<div class="toggle"><input type="checkbox" id="switcher" class="check"><b class="b switch"></b></div>';
			                            echo '<label class="toggler" id="filt-yearly">'.esc_html($settings['year']).'</label>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }    
		            echo '</div>';

		            echo '<div id="monthly" class="wrapper-full">';
		                echo '<div class="row gy-4 justify-content-center">';
		                	$counter = 1;
		                	foreach( $settings['price_lists'] as $key => $data ){
		                		if($counter == '2'){
		                    		$active_class = "active";
		                    	}else{
		                    		$active_class = "";
		                    	}
			                    echo '<div class="col-xl-4 col-md-6">';
			                        echo '<div class="price-box style2 th-ani '.esc_attr($active_class).'">';
			                            echo '<div class="">';
			                            	if(!empty($data['title'])){
			                                	echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
			                                }
			                                if(!empty($data['price'])){	
			                                	echo '<h4 class="box-price">'.esc_html($data['price']).'<span class="duration">'.esc_html($data['month']).'</span></h4>';
			                                }
			                                if(!empty($data['subtitle'])){		
			                                	echo '<p class="box-text2">'.esc_html($data['subtitle']).'</p>';
			                                }	
			                            echo '</div>';
			                            if(!empty($data['features'])){
				                            echo '<div class="box-content">';
				                                echo '<div class="available-list">';
				                                    echo '<ul>';
				                                        echo wp_kses_post($data['features']);
				                                    echo '</ul>';
				                                echo '</div>';
				                            echo '</div>';
			                            }
			                            if(!empty($data['button_text'])){	
			                            	echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style4 btn-fw th-radius th-icon">'.wp_kses_post($data['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
			                            }	
			                        echo '</div>';
			                    echo '</div>';
			                    $counter++;
			                }    	
		                echo '</div>';
		            echo '</div>';
		            echo '<div id="yearly" class="wrapper-full hide">';
		                echo '<div class="row gy-4 justify-content-center">';
		                	$counter = 1;
		                	foreach( $settings['price_lists2'] as $key => $data ){
		                		if($counter == '2'){
		                    		$active_class = "active";
		                    	}else{
		                    		$active_class = "";
		                    	}
			                    echo '<div class="col-xl-4 col-md-6">';
			                        echo '<div class="price-box style2 th-ani '.esc_attr($active_class).'">';
			                            echo '<div class="">';
			                            	if(!empty($data['title'])){
			                                	echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
			                                }
			                                if(!empty($data['price'])){	
			                                	echo '<h4 class="box-price">'.esc_html($data['price']).'<span class="duration">'.esc_html($data['month']).'</span></h4>';
			                                }
			                                if(!empty($data['subtitle'])){		
			                                	echo '<p class="box-text2">'.esc_html($data['subtitle']).'</p>';
			                                }	
			                            echo '</div>';
			                            if(!empty($data['features'])){
				                            echo '<div class="box-content">';
				                                echo '<div class="available-list">';
				                                    echo '<ul>';
				                                        echo wp_kses_post($data['features']);
				                                    echo '</ul>';
				                                echo '</div>';
				                            echo '</div>';
			                            }
			                            if(!empty($data['button_text'])){	
			                            	echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style4 btn-fw th-radius th-icon">'.wp_kses_post($data['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
			                            }	
			                        echo '</div>';
			                    echo '</div>';
			                    $counter++;
			                }    
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</section>';

		}elseif($settings['layout_style'] == '2' ){

			 echo '<section class="overflow-hidden">';
		        echo ' <div class="container">';
		            echo ' <div class="title-area text-center">';
		            	if(!empty($settings['sec_subtitle'])){	
		                	echo '<span class="sub-title sub-title6 style1 text-ani-style2">'.esc_html($settings['sec_subtitle']).'</span>';
		                }
		                if(!empty($settings['sec_title'])){		
		                	echo '<h2 class="sec-title">'.esc_html($settings['sec_title']).'</h2>';
		                }	
		                if(!empty($settings['month'] || $settings['year'])){
			                echo '<div class="pricing-tabs style2">';
			                    echo '<div class="switch-area">';
			                        echo '<label class="toggler toggler--is-active ms-0" id="filt-monthly">'.esc_html($settings['month']).'</label>';
			                        echo '<div class="toggle">';
			                            echo '<input type="checkbox" id="switcher" class="check">';
			                            echo '<b class="b switch"></b>';
			                        echo '</div>';
			                        echo '<label class="toggler" id="filt-yearly">'.esc_html($settings['year']).'</label>';
			                    echo '</div>';
			                echo '</div>';
			            }    
		             echo '</div>';
		             echo '<div id="monthly" class="wrapper-full">';
		                echo '<div class="row gy-4 justify-content-center">';
		                 	$counter = 1;
		                    foreach( $settings['price_list3'] as $key => $data ){
		                    	if($counter == '2'){
		                    		$active_class = "active";
		                    	}else{
		                    		$active_class = "";
		                    	}
			                    echo '<div class="col-xl-4 col-md-6">';
			                        echo '<div class="price-box th-ani '.esc_attr($active_class).'">';
			                        	if(!empty($data['offer_tag'])){
			                            	echo '<span class="offer-tag">'.esc_html($data['offer_tag']).'</span>';
			                            }	
			                            echo '<div class="text-center">';
			                            	if(!empty($data['title'])){
			                                	echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
			                                }	
			                                if(!empty($data['price'])){
			                                	echo '<h4 class="box-price">'.esc_html($data['price']).'<span class="duration">'.esc_html($data['month']).'</span></h4>';
			                                }	
			                                if(!empty($data['subtitle'])){
			                                	echo '<p class="box-text2">'.esc_html($data['subtitle']).'</p>';
			                                }	
			                            echo ' </div>';
			                            if(!empty($data['button_text'])){
			                            	echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style4 btn-fw th-radius th-icon">'.esc_html($data['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
			                            }
			                            if(!empty($data['features'])){	
				                            echo ' <div class="box-content">';
				                                echo '<div class="available-list">';
				                                    echo '<ul>';
				                                      	echo wp_kses_post($data['features']);
				                                    echo '</ul>';
				                                echo '</div>';
				                            echo '</div>';
				                        }
			                        echo '</div>';
			                    echo '</div>';
			                    $counter++;
			                }    
		                echo '</div>';
		            echo ' </div>';
		            echo '<div id="yearly" class="wrapper-full hide">';
		                echo '<div class="row gy-4 justify-content-center">';
		                	$counter = 1;
		                    foreach( $settings['price_lists4'] as $key => $data ){
		                    	if($counter == '2'){
		                    		$active_class = "active";
		                    	}else{
		                    		$active_class = "";
		                    	}
			                    echo '<div class="col-xl-4 col-md-6">';
			                        echo '<div class="price-box th-ani '.esc_attr($active_class).'">';
			                        	if(!empty($data['offer_tag'])){
			                            	echo '<span class="offer-tag">'.esc_html($data['offer_tag']).'</span>';
			                            }	
			                            echo '<div class="text-center">';
			                            	if(!empty($data['title'])){
			                                	echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
			                                }	
			                                if(!empty($data['price'])){
			                                	echo '<h4 class="box-price">'.esc_html($data['price']).'<span class="duration">'.esc_html($data['month']).'</span></h4>';
			                                }	
			                                if(!empty($data['subtitle'])){
			                                	echo '<p class="box-text2">'.esc_html($data['subtitle']).'</p>';
			                                }	
			                            echo ' </div>';
			                            if(!empty($data['button_text'])){
			                            	echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style4 btn-fw th-radius th-icon">'.esc_html($data['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
			                            }
			                            if(!empty($data['features'])){	
				                            echo ' <div class="box-content">';
				                                echo '<div class="available-list">';
				                                    echo '<ul>';
				                                      	echo wp_kses_post($data['features']);
				                                    echo '</ul>';
				                                echo '</div>';
				                            echo '</div>';
				                        }
			                        echo '</div>';
			                    echo '</div>';
			                    $counter++;
			                }   

		                echo '</div>';
		            echo ' </div>';
		         echo '</div>';
		    echo ' </section>';

		    }elseif($settings['layout_style'] == '4' ){

			    echo '<div class="title-area text-center">';
			    	if(!empty($settings['sec_subtitle'])){
	                	echo '<span class="sub-title sub-title8 style1">'.esc_html($settings['sec_subtitle']).'</span>';
	                }
	                if(!empty($settings['sec_title'])){	
		                echo '<h2 class="sec-title">'.esc_html($settings['sec_title']).'</h2>';
		            }
		            if(!empty($settings['month'] || $settings['year'])){	
		                echo '<div class="pricing-tabs style4">';
		                    echo '<div class="switch-area">';
		                       echo '<label class="toggler toggler--is-active ms-0" id="filt-monthly">'.esc_html($settings['month']).'</label>';
		                        echo '<div class="toggle">';
		                            echo '<input type="checkbox" id="switcher" class="check">';
		                            echo '<b class="b switch"></b>';
		                        echo '</div>';
		                        echo '<label class="toggler" id="filt-yearly">'.esc_html($settings['year']).'</label>';
		                    echo '</div>';
		                echo ' </div>';
	                }
	            echo '</div>';
	            echo '<div id="monthly" class="wrapper-full">';
	                echo '<div class="row gy-4 justify-content-center align-items-center">';
	                	$counter = 1;
	                    foreach( $settings['price_list3'] as $key => $data ){
	                    	if($counter == '2'){
	                    		$active_class = "active";
	                    	}else{
	                    		$active_class = "";
	                    	}
		                    echo '<div class="col-xl-4 col-md-6">';
		                        echo '<div class="price-grid th-ani '.esc_attr($active_class).'">';
		                            if(!empty($data['offer_tag'])){
		                            	echo '<span class="offer-tag">'.esc_html($data['offer_tag']).'</span>';
		                            }
		                            echo '<div class="">';
		                                if(!empty($data['title'])){
		                                	echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
		                                }	
		                                if(!empty($data['price'])){
		                                	echo '<h4 class="box-price">'.esc_html($data['price']).'<span class="duration">'.esc_html($data['month']).'</span></h4>';
		                                }	
		                            echo '</div>';
		                            if(!empty($data['button_text'])){
		                            	echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style4 btn-fw th-icon">'.esc_html($data['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
		                            }
		                            echo '<div class="box-content">';
		                                echo '<div class="available-list">';
		                                    echo '<ul>';
		                                       	echo wp_kses_post($data['features']);
		                                    echo '</ul>';
		                                echo '</div>';
		                            echo '</div>';

		                       echo ' </div>';
		                    echo '</div>';
		                 $counter++;
				        }       
	                echo '</div>';
	            echo '</div>';
	            echo '<div id="yearly" class="wrapper-full hide">';
	                echo '<div class="row gy-4 justify-content-center align-items-center">';

	                    $counter = 1;
	                    foreach( $settings['price_lists4'] as $key => $data ){
	                    	if($counter == '2'){
	                    		$active_class = "active";
	                    	}else{
	                    		$active_class = "";
	                    	}
		                    echo '<div class="col-xl-4 col-md-6">';
		                        echo '<div class="price-grid th-ani '.esc_attr($active_class).'">';
		                            if(!empty($data['offer_tag'])){
		                            	echo '<span class="offer-tag">'.esc_html($data['offer_tag']).'</span>';
		                            }
		                            echo '<div class="">';
		                                if(!empty($data['title'])){
		                                	echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
		                                }	
		                                if(!empty($data['price'])){
		                                	echo '<h4 class="box-price">'.esc_html($data['price']).'<span class="duration">'.esc_html($data['month']).'</span></h4>';
		                                }	
		                            echo '</div>';
		                            if(!empty($data['button_text'])){
		                            	echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style4 btn-fw th-icon">'.esc_html($data['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
		                            }
		                            echo '<div class="box-content">';
		                                echo '<div class="available-list">';
		                                    echo '<ul>';
		                                       	echo wp_kses_post($data['features']);
		                                    echo '</ul>';
		                                echo '</div>';
		                            echo '</div>';

		                       echo ' </div>';
		                    echo '</div>';
		                 $counter++;
				        }       

	                echo '</div>';
	            echo '</div>';
		}


	}

}