<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
/**
 *
 * Team Info Widget
 *
 */
class Saor_Footer_Contact extends Widget_Base{

	public function get_name() {
		return 'saor_footer_contact';
	}
	public function get_title() {
		return esc_html__( 'Footer Contact ', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'footer_contact_content',
			[
				'label'		=> esc_html__( 'Footer Contact ','saor' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] );

		saor_general_fields( $this, 'title', 'Title', 'TEXTAREA', 'Title', ['1'] );


		$contact_info = new Repeater();

		saor_media_fields($contact_info, 'icon_image', 'Icon Image');
		saor_general_fields($contact_info, 'title', 'Title', 'TEXTAREA2', 'Default Title');

		$this->add_control(
			'contact_info', [
				'label' 		=> __( 'Contact Info', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $contact_info->get_controls(),
				'title_field' => '{{{ title }}}',
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		
		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
		saor_common_style_fields( $this, '01', 'Title', '{{WRAPPER}} .widget_title'  );
		saor_common_style_fields( $this, '02', 'Info', '{{WRAPPER}} .box-desig,{{WRAPPER}} .box-desig a' );

	}

	protected function render() {

	$settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){

            echo '<div class="widget footer-widget">';
            	if(!empty($settings['title'])):
                	echo '<h3 class="widget_title">'.esc_html($settings['title']).'</h3>';
                endif;	
                echo '<div class="th-widget-contact">';
                	foreach( $settings['contact_info'] as $data ){
	                    echo '<div class="info-box">';
	                        echo '<div class="box-icon">';
	                            echo saor_img_tag( array(
									'url'   => esc_url( $data['icon_image']['url']  ),
								));
	                        echo '</div>';
	                        echo '<p class="box-text">'.wp_kses_post($data['title']).'</p>';
	                    echo '</div>';
                    }
                echo '</div>';
            echo '</div>';

		}
		
		
	}
}