<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
/**
 *
 * Team Info Widget
 *
 */
class Saor_Footer_About extends Widget_Base{

	public function get_name() {
		return 'saora_footer_about';
	}
	public function get_title() {
		return esc_html__( 'Footer About', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'footer_subscribe_content',
			[
				'label'		=> esc_html__( 'Footer Subscribe','saor' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] );

		saor_media_fields($this, 'image', 'Choose Image');
		saor_general_fields($this, 'desc', 'Description', 'TEXTAREA', 'Description');

		$this->add_control(
			'social',
			[
				'label' 		=> __('Social Url', 'rakar'),
				'type' 			=> Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'default' 	=> __('Social Url', 'rakar'),
				'condition'		=> [
					'layout_style' => ['1']
				],
			]
		);
		
		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
		saor_common_style_fields( $this, '01', 'Description', '{{WRAPPER}} .about-text'  );
	}

	protected function render() {

	$settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){
	        echo '<div class="widget footer-widget">';
                echo '<div class="th-widget-about">';
                    echo '<div class="about-logo">';
                        echo '<a class="icon-masking" href="'.home_url('/').'">';
                        	echo saor_img_tag( array(
								'url'   => esc_url( $settings['image']['url'] ),
							)); 
                       	echo ' </a>';
                    echo ' </div>';
                    if(!empty($settings['desc'])):
                    	echo '<p class="about-text">'.wp_kses_post($settings['desc']).'</p>';
                    endif;
                    if(!empty($settings['social'])):
	                    echo '<div class="th-social">';
	                       echo wp_kses_post($settings['social']);
	                    echo '</div>';
	                endif;
                echo '</div>';
            echo '</div>';
		}
		
		
	}
}