<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * CTA Widget .
 *
 */
class Saor_Cta extends Widget_Base {

	public function get_name() {
		return 'saorcta';
	}
	public function get_title() {
		return __( 'CTA', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'CTA', 'saor' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT, 
				
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two' ] );

		
		saor_general_fields($this, 'title', 'Title', 'TEXTAREA2', 'Title',['1','2']);
		saor_general_fields($this, 'subtitle', 'Subtitle', 'TEXTAREA', 'Subtitle',['1']); 
		saor_url_fields($this, 'video_url', 'Video URL',['1']);
		saor_general_fields($this, 'button_text', 'Button Text', 'TEXTAREA', 'Button Text',['2']); 
		saor_url_fields($this, 'button_url', 'Button URL',['2']);
		saor_general_fields($this, 'arrow_icon', 'Icon', 'TEXT', '<i class="fa-solid fa-play"></i>',['1','2']);
		saor_media_fields($this, 'choose_image', 'Choose Image',['1','2']);
		saor_media_fields($this, 'choose_shape', 'Choose Shape',['1','2']);

        $this->end_controls_section();

       	//---------------------------------------
			//Style Section Start
		//--------------------------------------- 

		//-------Title Style-------
		saor_common_style_fields( $this, '01', 'Title', '{{WRAPPER}} .sec-title' , ['1','2']);

        saor_button_style_fields($this, '10', 'Button Styling', '{{WRAPPER}} .th-btn,{{WRAPPER}} .line-btn', ['1','2']);

	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

		    echo '<section class="cta-sec2 overflow-hidden space-bottom" data-pos-for=".testi-sec" data-sec-pos="top-half">';
		       echo ' <div class="container">';
		            echo '<div class="cta-area4">';
			            if(!empty($settings['title'])){
			                echo '<div class="title-area mb-0">';
			                    echo '<h3 class="sec-title text-ani-style3 text-white mb-0">'.wp_kses_post($settings['title']).'</h3>';
			                echo '</div>';
			            }
		                echo ' <div class="cta-play-btn">';
		                    echo '<div class="discount-wrapp">';
		                    	if(!empty($settings['video_url']['url'])){
		                        	echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="play-btn popup-video">';
		                        	echo wp_kses_post($settings['arrow_icon']);
		                        	echo '</a>';
		                        }
		                        if(!empty($settings['subtitle'])){   
			                        echo '<div class="discount-tag">';
			                            echo '<span class="discount-anime">'.wp_kses_post($settings['subtitle']).'</span>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo ' </div>';
		                if(!empty($settings['choose_image']['url'])){
			                echo '<div class="cta-image">';
			                    echo saor_img_tag( array(
									'url'   => esc_url( $settings['choose_image']['url'] ),
								));
			                echo '</div>';
			            }
			            if(!empty($settings['choose_shape']['url'])){    
			                echo '<div class="cta-shate">';
			               		echo saor_img_tag( array(
									'url'   => esc_url( $settings['choose_shape']['url'] ),
								));
			                echo '</div>';
			            }    
		            echo '</div>';
		        echo '</div>';
		    echo '</section>';

		}elseif( $settings['layout_style'] == '2' ){

		        echo '<div class="container">';
		            echo '<div class="cta-area3" data-bg-src="'.esc_url( $settings['choose_shape']['url'] ).'">';
		            	if(!empty($settings['choose_image']['url'])){
			                echo '<div class="cta-image1">';
			                  	echo saor_img_tag( array(
									'url'   => esc_url( $settings['choose_image']['url'] ),
								));
			                echo '</div>';
			            }
			            if(!empty($settings['title'])){    
			                echo '<div class="title-area mb-0">';
			                    echo '<h3 class="sec-title mb-0">'.wp_kses_post($settings['title']).'</h3>';
			                echo '</div>';
			            }
			            if(!empty($settings['button_text'])){     
			                echo '<div class="btn-group">';
			                    echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn th-radius3 th-icon th-black3">'.wp_kses_post($settings['button_text']);
			                     	echo wp_kses_post($settings['arrow_icon']);
			                    echo '</a>';
			                echo '</div>';
			            }
		            echo '</div>';
		       echo ' </div>';
		}
		

	}

}