<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Form Widget .
 *
 */
class Saor_Contact_Form extends Widget_Base {

	public function get_name() {
		return 'saorcontactform';
	}
	public function get_title() {
		return __( 'Contact Form', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	public function get_as_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $as_cfa         = array();
        $as_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $as_forms       = get_posts( $as_cf_args );
        $as_cfa         = ['0' => esc_html__( 'Select Form', 'saor' ) ];
        if( $as_forms ){
            foreach ( $as_forms as $as_form ){
                $as_cfa[$as_form->ID] = $as_form->post_title;
            }
        }else{
            $as_cfa[ esc_html__( 'No contact form found', 'saor' ) ] = 0;
        }
        return $as_cfa;
    }

	protected function register_controls() {

		$this->start_controls_section(
			'contact_form_section',
			[
				'label' 	=> __( 'Contact Form', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two'] ); 

		$this->add_control(
            'saor_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'saor' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_as_contact_form(),
            ]
        );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		saor_common_style_fields( $this, '01', 'Title', '{{WRAPPER}} .contact-form h3', ['1'] );
		saor_button_style_fields($this, '02', 'Button Styling', '{{WRAPPER}} .th-btn',['1']);


	}

	protected function render() {

	    $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
		    echo '<div class="search-contact text-center">';
                if( !empty($settings['saor_select_contact_form']) ){
						echo do_shortcode( '[contact-form-7  id="'.$settings['saor_select_contact_form'].'"]' ); 
				}else{
					echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'saor' ). '</p></div>';
				}
            echo '</div>';    

		}elseif( $settings['layout_style'] == '2'){

			echo '<div class="contact-form2 input-smoke">';  
                if( !empty($settings['saor_select_contact_form']) ){
						echo do_shortcode( '[contact-form-7  id="'.$settings['saor_select_contact_form'].'"]' ); 
				}else{
					echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'saor' ). '</p></div>';
				}

            echo '</div>';  
		}
		

	}

}