<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * features Widget .
 *
 */
class Saor_Client_Logos extends Widget_Base {

	public function get_name() {
		return 'saorclientlogos';
	}
	public function get_title() {
		return __( 'Client Logos', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'arrow_section',
			[
				'label'     => __( 'Client Logos', 'saor' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three','Style Four','Style Five'] );

		saor_general_fields($this, 'title', 'Title', 'TEXTAREA2', 'Title', [ '3','5'] );

		$client_list = new Repeater();
		
		saor_media_fields( $client_list, 'client_image', 'Choose Image');
		saor_url_fields($client_list, 'url', 'URL');

		$this->add_control(
			'client_list',
			[
				'label' 		=> __( 'Client Image', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $client_list->get_controls(),
				'condition'	=> [
					'layout_style' => ['1','2','3','4','5']
				]
			]
		);

		saor_media_fields( $this, 'shape', 'Shape', ['3','5'] );


        $this->end_controls_section();

        saor_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .title-area h3' );

        //---------------------------------------
			//Style Section Start
		//---------------------------------------


	}

	protected function render() {

    $settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){
            echo '<div class="brand-area overflow-hidden">';
		         echo '<div class="container th-container">';
		             echo '<div class="slider-area text-center">';
		                 echo '<div class="swiper th-slider" id="brandSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"476":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"6"}}}\'>';
		                     echo '<div class="swiper-wrapper">';
		                     	foreach( $settings['client_list'] as $data ){
			                        echo '<div class="swiper-slide">';
			                             echo '<div class="brand-item style2">';
			                                 echo '<a href="'.esc_url($data['url']['url']).'">';
		                                     	echo saor_img_tag( array(
		                                            'url'   => esc_url( $data['client_image']['url'] ),
		                                            'class' => 'original'
		                                        ) );
		                                     	echo saor_img_tag( array(
		                                            'url'   => esc_url( $data['client_image']['url'] ),
		                                            'class' => 'gray'
		                                        ) );
			                                 echo '</a>';
			                            echo ' </div>';
			                         echo '</div>';
		                        }
		                     echo '</div>';

		                 echo '</div>';
		             echo '</div>';
		        echo ' </div>';
		    echo '</div>';
		}elseif($settings['layout_style'] == '2'){

			echo '<div class="brand-sec pt-60 pb-60 bg-theme overflow-hidden">';
		        echo '<div class="container th-container">';
		            echo '<div class="slider-area text-center">';
		                echo '<div class="swiper th-slider" id="brandSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"476":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"6"}}}\'>';
		                    echo '<div class="swiper-wrapper">';
		                    	foreach( $settings['client_list'] as $data ){
			                        echo '<div class="swiper-slide">';
			                            echo '<div class="brand-item style3">';
			                                echo '<a href="'.esc_url($data['url']['url']).'">';
			                                    echo saor_img_tag( array(
		                                            'url'   => esc_url( $data['client_image']['url'] ),
		                                            'class' => 'original'
		                                        ) );
		                                     	echo saor_img_tag( array(
		                                            'url'   => esc_url( $data['client_image']['url'] ),
		                                            'class' => 'gray'
		                                        ) );
			                                echo '</a>';
			                            echo '</div>';
			                        echo '</div>';
		                       	}
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif($settings['layout_style'] == '3'){
			echo '<div class="brand-sec overflow-hidden bg-smoke2 space-extra2 overflow-hidden">';
		        echo '<div class="container th-container">';
		        	if(!empty($settings['title'])):
			            echo '<div class="title-area mb-60 text-center">';
			            	if(!empty($settings['title'])){
			                	echo '<h3 class="brand-title2 mt-n3 text-ani-style3">'.esc_html($settings['title']).'</h3>';
			                }	
			                if(!empty($settings['shape']['url'])){
				                echo saor_img_tag( array(
		                            'url'   => esc_url( $settings['shape']['url'] ),
		                        ) );
				            }
			            echo '</div>';
			        endif;    
		            echo '<div class="slider-area text-center">';
		                echo '<div class="swiper th-slider" id="brandSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"476":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"6"}}}\'>';
		                    echo '<div class="swiper-wrapper">';
		                    	foreach( $settings['client_list'] as $data ){
			                        echo '<div class="swiper-slide">';
			                            echo '<div class="brand-item style4">';
			                                echo '<a href="'.esc_url($data['url']['url']).'">';
			                                    echo saor_img_tag( array(
		                                            'url'   => esc_url( $data['client_image']['url'] ),
		                                            'class' => 'original'
		                                        ) );
		                                     	echo saor_img_tag( array(
		                                            'url'   => esc_url( $data['client_image']['url'] ),
		                                            'class' => 'gray'
		                                        ) );
			                                echo '</a>';
			                           echo ' </div>';
			                        echo '</div>';
		                        }
		                    echo '</div>';

		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif($settings['layout_style'] == '4'){

			echo '<div class="brand-sec overflow-hidden bg-smoke2 bg-white space-bottom">';
		        echo '<div class="container th-container">';
		            echo '<div class="slider-area text-center">';
		                echo '<div class="swiper th-slider" id="brandSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"476":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"6"}}}\'>';
		                    echo '<div class="swiper-wrapper">';
		                    	foreach( $settings['client_list'] as $data ){
			                        echo '<div class="swiper-slide">';
			                           echo ' <div class="brand-item style4">';
			                                echo '<a href="'.esc_url($data['url']['url']).'">';
			                                    echo saor_img_tag( array(
		                                            'url'   => esc_url( $data['client_image']['url'] ),
		                                            'class' => 'original'
		                                        ) );
		                                     	echo saor_img_tag( array(
		                                            'url'   => esc_url( $data['client_image']['url'] ),
		                                            'class' => 'gray'
		                                        ) );
			                               echo ' </a>';
			                           echo ' </div>';
			                       	echo ' </div>';
		                        }
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		   echo ' </div>';

		}elseif($settings['layout_style'] == '5'){

			echo '<div class="brand-sec overflow-hidden space">';
		        echo '<div class="container th-container">';
		            echo '<div class="title-area mb-60 text-center">';
		                if(!empty($settings['title'])){
		                	echo '<h3 class="brand-title2 mt-n3 anime-heading-title">'.esc_html($settings['title']).'</h3>';
		                }	
		                if(!empty($settings['shape']['url'])){
			                echo saor_img_tag( array(
	                            'url'   => esc_url( $settings['shape']['url'] ),
	                        ) );
			            }
		            echo '</div>';
		            echo '<div class="slider-area text-center">';
		                echo '<div class="swiper th-slider" id="brandSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"476":{"slidesPerView":"2"},"768":{"slidesPerView":"3"},"992":{"slidesPerView":"4"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"6"}}}\'>';
		                    echo '<div class="swiper-wrapper">';
		                    	foreach( $settings['client_list'] as $data ){
			                        echo '<div class="swiper-slide">';
			                            echo '<div class="brand-item style4">';
			                                echo '<a href="">';
			                                    echo saor_img_tag( array(
		                                            'url'   => esc_url( $data['client_image']['url'] ),
		                                            'class' => 'original'
		                                        ) );
		                                     	echo saor_img_tag( array(
		                                            'url'   => esc_url( $data['client_image']['url'] ),
		                                            'class' => 'gray'
		                                        ) );
			                                echo '</a>';
			                            echo '</div>';
			                        echo '</div>';
		                       	}
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		       echo ' </div>';
		    echo '</div>';

		}
	}
}