<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Choose Widget .
 *
 */
class Saor_Choose extends Widget_Base {

	public function get_name() {
		return 'saorChoose';
	}
	public function get_title() {
		return __( 'Choose', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'choose_section',
			[
				'label' 	=> __( 'Choose', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] ); 

        $choose_list = new Repeater();

        saor_general_fields($choose_list, 'title', 'Title', 'TEXTAREA2', 'Default Title');
        saor_general_fields($choose_list, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Default Subtitle');
        saor_media_fields($choose_list, 'image', 'Icon Image');

        $this->add_control(
            'choose_list',
            [
                'label'         => __( 'Choose List', 'saor' ),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $choose_list->get_controls(),
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout_style' => ['1']
                ]
            ]
        );


		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
        //-------Title Style-------
        saor_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .title' );
        //------Button Style (gradient-color)-------
        saor_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th_btn' );


	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

            echo '<div class="choose-feature-wrap">';
            	foreach( $settings['choose_list'] as $key => $data ){
	                echo '<div class="choose-feature">';
	                    echo '<div class="box-icon">';
	                        echo saor_img_tag( array(
								'url'   => esc_url( $data['image']['url'] ),
							));
	                    echo '</div>';
	                    echo '<div class="media-body">';
	                    	if(!empty($data['title'])){
	                    		echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
	                    	}

	                    	if(!empty($data['subtitle'])){
	                    		echo '<p class="box-text">'.esc_html($data['subtitle']).'</p>';
	                    	}	  
	                    echo '</div>';
	                echo '</div>';
                }
            echo '</div>';

		}

	
	}

}