<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Saor_Blog extends Widget_Base {

	public function get_name() {
		return 'saorblog';
	}
	public function get_title() {
		return __( 'Blog Post', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' => __( 'Blog Post', 'saor' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two','Style Three','Style Four','Style Five','Style Six','Style Eight'] );

        $this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'saor' ),
                'type' 		=> Controls_Manager::NUMBER,
                'min'       => 1,
                'max'       => count( get_posts( array('post_type' => 'post', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) ),
                'default'  	=> __( '3', 'saor' )
			]
        );

        saor_general_fields( $this, 'title_count', 'Title Length', 'TEXT2', '6');
        saor_general_fields( $this, 'excerpt_count', 'Excerpt Length', 'TEXT', '14', ['1', '2', '4']);

        $this->add_control(
			'blog_post_order',
			[
				'label' 	=> __( 'Order', 'saor' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ASC'   	=> __('ASC','saor'),
                    'DESC'   	=> __('DESC','saor'),
                ],
                'default'  	=> 'DESC'
			]
        );
        $this->add_control(
			'blog_post_order_by',
			[
				'label' 	=> __( 'Order By', 'saor' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ID'    	=> __( 'ID', 'saor' ),
                    'author'    => __( 'Author', 'saor' ),
                    'title'    	=> __( 'Title', 'saor' ),
                    'date'    	=> __( 'Date', 'saor' ),
                    'rand'    	=> __( 'Random', 'saor' ),
                ],
                'default'  	=> 'ID'
			]
        );
        $this->add_control(
			'exclude_cats',
			[
				'label' 		=> __( 'Exclude Categories', 'saor' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->saor_get_categories(),
			]
        );
        $this->add_control(
			'exclude_tags',
			[
				'label' 		=> __( 'Exclude Tags', 'saor' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->saor_get_tags(),
			]
        );
        $this->add_control(
			'exclude_post_id',
			[
				'label'         => __( 'Exclude Post', 'saor' ),
                'type'          => Controls_Manager::SELECT2,
                'multiple'      => true,
				'options'       => $this->saor_post_id(),
			]
        );

        saor_general_fields( $this, 'button_text', 'Read More Text', 'TEXTAREA2', 'Read More', ['1', '2','3','5','6'] );

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//--------------------------------------- 

		//-------Title Style-------
		saor_common_style_fields( $this, '01', 'Title', '{{WRAPPER}} .box-title a' );
		saor_common_style_fields( $this, '02', 'Content', '{{WRAPPER}} .box-text', ['1', '2', '4'] );
        saor_common_style_fields( $this, '03', 'Blog Meta', '{{WRAPPER}} .blog-meta a', ['1', '2', '4','5','3'] );

        saor_button_style_fields($this, '10', 'Button Styling', '{{WRAPPER}} .th-btn,{{WRAPPER}} .line-btn', ['1','5']);


    }

    public function saor_get_categories() {
        $cats = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));

        $cat = [];

        foreach( $cats as $singlecat ) {
            $cat[$singlecat->term_id] = __($singlecat->name,'saor');
        }

        return $cat;
    }

    public function saor_get_tags() {
        $tags = get_terms(array(
            'taxonomy' => 'post_tag',
            'hide_empty' => true,
        ));

        $tag = [];

        foreach( $tags as $singletag ) {
            $tag[$singletag->term_id] = __($singletag->name,'saor');
        }

        return $tag;
    }

    // Get Specific Post
    public function saor_post_id(){
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => -1,
        );

        $saor_post = new WP_Query( $args );

        $postarray = [];

        while( $saor_post->have_posts() ){
            $saor_post->the_post();
            $postarray[get_the_Id()] = get_the_title();
        }
        wp_reset_postdata();
        return $postarray;
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $exclude_post = $settings['exclude_post_id'];

        if( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats']
            );
        } elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags']
            );
        }elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
            );
        } elseif( empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'post__not_in'          => $exclude_post
            );
        } else {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true
            );
        }

    $blogpost = new WP_Query( $args );

		if( $settings['layout_style'] == '1' ){

            echo '<div class="row gy-5">';
                $counter = 1;
                while( $blogpost->have_posts() ){
                $blogpost->the_post(); 
                $categories = get_the_category();
                if($counter == '1'){
                    $column = esc_attr("6");
                }else{
                    $column = esc_attr("3");
                }
                    echo '<div class="col-xl-'.$column.' col-lg-12 blog-card_wrapp">';
                        echo '<div class="blog-card">';
                            echo '<div class="box-img global-img">';
                                if($counter == '1'){
                                    the_post_thumbnail( 'saor_633X352' );
                                }else{
                                    the_post_thumbnail( 'saor_305X355' );  
                                }    
                            echo '</div>';
                            echo '<div class="box-content">';
                                echo '<h3 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
                                if(!empty($settings['button_text'])){
                                    echo '<a href="'.esc_url( get_permalink() ).'" class="line-btn th-icon">'.esc_html($settings['button_text']).' <i class="fa-regular fa-arrow-right ms-2"></i></a>';
                                }    
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                    $counter++;
                }wp_reset_postdata();
            echo '</div>';

		}elseif( $settings['layout_style'] == '2'){

            echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="blogSlider3" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                         while( $blogpost->have_posts() ){
                        $blogpost->the_post(); 
                        $categories = get_the_category();
                            echo '<div class="swiper-slide">';
                                echo '<div class="blog-grid">';
                                    if(has_post_thumbnail()):
                                        echo '<div class="box-img global-img">';
                                            the_post_thumbnail( 'saor_414X353' ); 
                                        echo '</div>';
                                    endif;
                                    echo '<div class="box-content">';
                                        echo '<div class="blog-meta">';
                                            echo '<a href="'.esc_url( get_permalink() ).'"><i class="fa-light fa-calendar"></i>'.esc_html( get_the_date() ).'</a>';
                                            if(!empty($categories[0]->name)){
                                                echo '<a href="'.esc_url( get_permalink() ).'"><i class="fa-regular fa-clock"></i>'.esc_html( $categories[0]->name ).'</a>';
                                            }
                                        echo '</div>';
                                        echo '<h3 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
                                        if(!empty($settings['button_text'])){
                                            echo '<a href="'.esc_url( get_permalink() ).'" class="line-btn th-icon">'.esc_html($settings['button_text']).'<i class="fa-regular fa-arrow-right"></i></a>';
                                        } 
                                   echo ' </div>';
                                echo '</div>';
                            echo '</div>';
                        }wp_reset_postdata();     
                    echo '</div>';
                echo '</div>';
                echo '<button data-slider-prev="#blogSlider3" class="slider-arrow style3 slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#blogSlider3" class="slider-arrow style3 slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

        }elseif($settings['layout_style'] == '3'){

            echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="blogSlider4" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"2"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        while( $blogpost->have_posts() ){
                        $blogpost->the_post(); 
                        $categories = get_the_category();
                            echo '<div class="swiper-slide">';
                                echo '<div class="blog-card style2">';
                                    if(has_post_thumbnail()):
                                        echo '<div class="box-img global-img">';
                                             the_post_thumbnail( 'saor_633X403' ); 
                                        echo '</div>';
                                    endif;
                                    echo '<div class="box-content">';
                                        echo '<div class="blog-meta">';
                                            echo '<a href="'.esc_url( get_permalink() ).'"><i class="fa-light fa-calendar"></i>'.esc_html( get_the_date() ).'</a>';
                                           if(!empty($categories[0]->name)){
                                                echo '<a href="'.esc_url( get_permalink() ).'"><i class="fa-regular fa-clock"></i>'.esc_html( $categories[0]->name ).'</a>';
                                            }
                                        echo '</div>';
                                        echo '<h3 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
                                        if(!empty($settings['button_text'])){
                                            echo '<a href="'.esc_url( get_permalink() ).'" class="th-btn th-icon th-radius style2">'.esc_html($settings['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
                                        }    
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }wp_reset_postdata();        
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }elseif($settings['layout_style'] == '4'){
            echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="blogSlider2" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        while( $blogpost->have_posts() ){
                        $blogpost->the_post(); 
                        $categories = get_the_category();
                            echo '<div class="swiper-slide">';
                                echo '<div class="blog-box">';
                                    if(has_post_thumbnail()):
                                        echo '<div class="blog-img">';
                                            the_post_thumbnail( 'saor_414X353' ); 
                                        echo '</div>';
                                    endif;    
                                    echo '<div class="box-content">';
                                        echo '<div class="blog-meta">';
                                            echo '<a href="'.esc_url( get_permalink() ).'"><i class="fa-light fa-calendar"></i>'.esc_html( get_the_date() ).'</a>';
                                            if(!empty($categories[0]->name)){
                                                echo '<a href="'.esc_url( get_permalink() ).'"><i class="fa-regular fa-clock"></i>'.esc_html( $categories[0]->name ).'</a>';
                                            }
                                        echo '</div>';
                                        echo '<h3 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
                                        if(!empty($settings['button_text'])){
                                            echo '<a href="'.esc_url( get_permalink() ).'" class="th-btn th-icon th-radius style2">'.esc_html($settings['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }wp_reset_postdata();        
                    echo '</div>';
                echo '</div>';
                echo '<button data-slider-prev="#blogSlider2" class="slider-arrow style3 slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#blogSlider2" class="slider-arrow style3 slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

        }elseif($settings['layout_style'] == '5'){

            echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="blogSlider5" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        while( $blogpost->have_posts() ){
                        $blogpost->the_post(); 
                        $categories = get_the_category();
                            echo '<div class="swiper-slide">';
                                echo '<div class="blog-item">';
                                    if(has_post_thumbnail()){
                                        echo '<div class="box-img global-img">';
                                            the_post_thumbnail( 'saor_414X353' ); 
                                        echo '</div>';
                                    }   
                                    echo '<div class="box-content">';
                                        echo '<div class="blog-meta">';
                                            echo '<a href="'.esc_url( get_permalink() ).'"><i class="fa-light fa-calendar"></i>'.esc_html( get_the_date() ).'</a>';
                                            if(!empty($categories[0]->name)){
                                                echo '<a href="'.esc_url( get_permalink() ).'"><i class="fa-regular fa-clock"></i>'.esc_html( $categories[0]->name ).'</a>';
                                            }
                                        echo '</div>';
                                        echo '<h3 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
                                        echo '<div class="blog-btn"><a href="'.esc_url( get_permalink() ).'" class="line-btn">'.esc_html($settings['button_text']).'<i class="fa-solid fa-angles-right"></i></a> </div>';
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }wp_reset_postdata();
                   echo ' </div>';
                echo '</div>';
                echo '<button data-slider-prev="#blogSlider5" class="slider-arrow style3 slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#blogSlider5" class="slider-arrow style3 slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

        }elseif($settings['layout_style'] == '6'){

            echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="blogSlider4" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"2"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        while( $blogpost->have_posts() ){
                        $blogpost->the_post(); 
                        $categories = get_the_category();
                            echo '<div class="swiper-slide">';
                                echo '<div class="blog-card style3">';
                                    echo '<div class="box-img global-img">';
                                        the_post_thumbnail( 'saor_633X402' ); 
                                    echo '</div>';
                                    echo '<div class="box-content">';
                                       echo ' <div class="blog-meta">';
                                            echo '<a href="'.esc_url( get_permalink() ).'"><i class="fa-light fa-calendar"></i>'.esc_html( get_the_date() ).'</a>';
                                            if(!empty($categories[0]->name)){
                                                echo '<a href="'.esc_url( get_permalink() ).'"><i class="fa-regular fa-clock"></i>'.esc_html( $categories[0]->name ).'</a>';
                                            }
                                        echo '</div>';
                                        echo '<h3 class="box-title"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ).'</a></h3>';
                                        echo '<a href="'.esc_url( get_permalink() ).'" class="th-btn th-icon th-radius style2">'.esc_html($settings['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        }wp_reset_postdata();    
                       
                    echo '</div>';
                echo '</div>';
            echo '</div>';

        }
	
      
	}
}