<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Arrows Widget .
 *
 */
class Saor_Arrows extends Widget_Base {

	public function get_name() {
		return 'saorarrows';
	}
	public function get_title() {
		return __( 'Slider Arrow', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'arrow_section',
			[
				'label'     => __( 'Slider Arrows', 'saor' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three' ] );
		saor_general_fields($this, 'description', 'Description', 'TEXTAREA', 'Description',['2']);
		saor_general_fields($this, 'arrow_id', 'Arrow ID or Class', 'TEXT', '#blogSlider1');
		saor_general_fields($this, 'arrow_extra_class', 'Arrow Extra Class', 'TEXT', '');

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

	}

	protected function render() {

    $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="sec-btn '.esc_attr($settings['arrow_extra_class']).'">';
                echo '<div class="icon-box">';
                    echo '<button data-slider-next="'.esc_attr($settings['arrow_id']).'" class="slider-arrow default style-border slider-prev"><i class="far fa-arrow-left"></i></button>';
                    echo '<button data-slider-prev="'.esc_attr($settings['arrow_id']).'" class="slider-arrow default style-border slider-next"><i class="far fa-arrow-right"></i></button>';
                echo '</div>';
            echo '</div>';
			
		}elseif( $settings['layout_style'] == '2' ){
			if(!empty($settings['description'])){	
				echo '<p class="ps-xl-5 text-center text-lg-start">'.esc_html($settings['description']).'</p>';
			}	
            echo '<div class="sec-btn '.esc_attr($settings['arrow_extra_class']).'">';
                echo '<div class="icon-box">';
                    echo '<button data-slider-prev="'.esc_attr($settings['arrow_id']).'" class="slider-arrow style4 default"><i class="far fa-arrow-left"></i></button>';
                    echo '<button data-slider-next="'.esc_attr($settings['arrow_id']).'" class="slider-arrow style4 default"><i class="far fa-arrow-right"></i></button>';
                echo ' </div>';
            echo '</div>';

        }elseif( $settings['layout_style'] == '3' ){
        	echo '<div class="col-lg-auto d-none d-xl-block">';
	        	echo '<div class="sec-btn">';
	                echo '<div class="icon-box">';
	                    echo '<button data-slider-prev="'.esc_attr($settings['arrow_id']).'" class="slider-arrow style3 default"><i class="far fa-arrow-left"></i></button>';
	                    echo '<button data-slider-next="'.esc_attr($settings['arrow_id']).'" class="slider-arrow style3 default"><i class="far fa-arrow-right"></i></button>';
	                echo '</div>';
	            echo '</div>';
	        echo '</div>';    
		}
			
	}
}