<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Header Widget . 
 *
 */
class saor_Header extends Widget_Base {

	public function get_name() {
		return 'saorheader';
	}
	public function get_title() {
		return __( 'Header', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label' 	=> __( 'Header', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style',['Style One','Style Two','Style Three','Style Four','Style Five','Header Six','Header Seven','Header Eight'] );

		

		$this->add_control(
			'logo_image',

			[
				'label' 		=> __( 'Upload Logo', 'saor' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);				

		$menus = $this->saor_menu_select();

		if( !empty( $menus ) ){
	        $this->add_control(
				'saor_menu_select',
				[
					'label'     	=> __( 'Select saor Menu', 'saor' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'saor' ), admin_url( 'nav-menus.php' ) ),
				]
			);
		}else {
			$this->add_control(
				'no_menu',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . __( 'There are no menus in your site.', 'saor' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'saor' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}
	
		$this->add_control(
			'show_offcanvas_btn',
			[
				'label' 		=> __( 'Show Offcanvas Button?', 'saor' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'saor' ),
				'label_off' 	=> __( 'Hide', 'saor' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> [
					'layout_style' => ['5','6']
				]
			]
		);

		$this->add_control(
			'show_search_btn',
			[
				'label' 		=> __( 'Show Search Button?', 'donat' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'donat' ),
				'label_off' 	=> __( 'Hide', 'donat' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> [
					'layout_style' => ['1','2','3','4','5','6','7','8']
				]
			]
		);		

		$features = new Repeater();
		
		saor_general_fields($features, 'title', 'Title', 'TEXTAREA2', 'Default Title');
		saor_general_fields($features, 'icon', 'Icon', 'TEXT', '<i class="fa-regular fa-phone"></i>');

		$this->add_control(
			'topbar_info_list',
			[
				'label' 		=> __( 'Topbar Info', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $features->get_controls(),
				'title_field' => '{{{ title }}}',
				'condition'	=> [
					'layout_style' => ['3']
				]
			]
		);

		$this->add_control(
			'social_text',
			[
				'label' 		=> __('Social Text', 'rakar'),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 	=> __('Social Text', 'rakar'),
				'condition'		=> [
					'layout_style' => ['3']
				],
			]
		);

		$this->add_control(
			'social',
			[
				'label' 		=> __('Social Url', 'rakar'),
				'type' 			=> Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'default' 	=> __('Social Url', 'rakar'),
				'condition'		=> [
					'layout_style' => ['3']
				],
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' 		=> __( 'Button Text', 'saor' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 	=> __( 'Button Label', 'saor' ),
				'condition'	=> [
					'layout_style' => ['1','2','3','4','5','7','8']
				]
			]
		);
		
		$this->add_control(
			'button_url',
			[
				'label' 		=> esc_html__( 'Button Link', 'saor' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'saor' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> [
					'layout_style' => ['1','2','3','4','5','7','8']
				]
			]
		);

		$this->add_control(
			'contact_icon',
			[
				'label' 		=> __( 'Icon', 'saor' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 	=> __( ' <i class="fa-regular fa-arrow-right ms-2"></i>', 'saor' ),
				'condition'		=> [
					'layout_style' => ['1','2']
				],
			]
		);

		$this->add_control(
			'contact_title',
			[
				'label' 		=> __( 'Contact Title', 'saor' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 	=> __( 'Contact Title', 'saor' ),
				'condition'		=> [
					'layout_style' => ['9']
				],
			]
		);

		$this->add_control(
			'contact_info',
			[
				'label' 		=> __( 'Contact Info', 'saor' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 	=> __( 'Contact Info', 'saor' ),
				'condition'		=> [
					'layout_style' => ['9']
				],
			]
		);

		

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------General Style-------
		 $this->start_controls_section(
			'general_styling',
			[
				'label'     => __( 'Background Styling', 'saor' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );


		saor_color_fields( $this, 'menu_bg', 'Background', 'background', '{{WRAPPER}} .header-layout-control, {{WRAPPER}} .header-layout-control .sticky-wrapper', ['1','2'] );         
      
       

		$this->end_controls_section();

		//------Menu Bar Style-------
        $this->start_controls_section(
			'menubar_styling2',
			[
				'label'     => __( 'Menu Styling', 'saor' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

		saor_color_fields( $this, 'menu_color1', 'Color', 'color', '{{WRAPPER}} .main-menu>ul>li>a', ['1','2','3'] );
		saor_color_fields( $this, 'menu_color2', 'Hover Color', 'color', '{{WRAPPER}} .main-menu>ul>li>a:hover', ['1','2','3'] );
		saor_color_fields( $this, 'menu_color3', 'Dropdown Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a' );
		saor_color_fields( $this, 'menu_color4', 'Dropdown Hover Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a:hover' );
		saor_color_fields( $this, 'menu_color5', 'Menu Icon Color', 'color', '{{WRAPPER}} .main-menu ul.sub-menu li a:before, {{WRAPPER}} .main-menu ul li.menu-item-has-children > a:after' );

		saor_typography_fields( $this, 'menu_font', 'Menu Trpography', '{{WRAPPER}} .main-menu>ul>li>a, {{WRAPPER}} .main-menu ul.sub-menu li a' );

		saor_dimensions_fields( $this, 'menu_margin', 'Menu Margin', 'margin', '{{WRAPPER}} .main-menu>ul>li>a' );
		saor_dimensions_fields( $this, 'menu_padding', 'Menu Padding', 'padding', '{{WRAPPER}} .main-menu>ul>li>a' );

		$this->end_controls_section();

		//------Button Style-------
		saor_button_style_fields( $this, '12', 'Button Styling', '{{WRAPPER}} .btn-mask, {{WRAPPER}} .th-btn' );

    }

    public function saor_menu_select(){
	    $saor_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'saor' );
	    foreach( $saor_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		global $woocommerce;

        //Menu by menu select
        $saor_avaiable_menu   = $this->saor_menu_select();
		if( ! $saor_avaiable_menu ){
			return;
		}
		$args = [
			'menu' 			=> $settings['saor_menu_select'],
			'menu_class' 	=> 'saor-menu',
			'container' 	=> '',
		];

		//Mobile menu, Offcanvas, Search
        echo saor_mobile_menu();
		// echo saor_header_cart_offcanvas();

			echo saor_header_offcanvas();
		
		if(!empty( $settings['show_search_btn'])){
			echo saor_search_box();
		}
		// Header sub-menu icon
		if( class_exists( 'ReduxFramework' ) ){ 
			if(saor_opt('saor_header_sticky')){
                $sticky = '';
            }else{
                $sticky = '-no';
            }

			if(saor_opt('saor_menu_icon')){
				$menu_icon = '';
			}else{
				$menu_icon = 'hide-icon';
			}
		}
	

		if( $settings['layout_style'] == '1' ){

		    echo '<div class="th-header header-layout1 header-absolute">';
		        echo '<div class="sticky-wrapper '.esc_attr($sticky).'">';
		            echo '<div class="container th-container">';
		                echo '<div class="menu-area">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo saor_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                            echo '<nav class="main-menu style2 d-none d-lg-inline-block">';
		                                if( ! empty( $settings['saor_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';
		                            echo '<div class="header-button">';
		                                echo '<button type="button" class="th-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-lg-block">';
		                            echo '<div class="header-button">';
		                            	if($settings['show_search_btn'] == 'yes'){
		                            		echo '<button type="button" class="icon-btn searchBoxToggler"><i class="fal fa-search"></i></button>';
		                            	}
		                                
		                                if( ! empty( $settings['button_text'] ) ){
		                                	echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn th-icon">'. wp_kses_post( $settings['button_text'] ).wp_kses_post( $settings['contact_icon'] ).'</a>';
		                            	}  

		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		    echo '<div class="popup-search-box d-none d-lg-block">';
		        echo '<button class="searchClose"><i class="fal fa-times"></i></button>';
		        echo '<form role="search" method="get" action="' . esc_url(home_url('/')) . '">';
		            echo '<input type="text" value="' . esc_html(get_search_query()) . '" name="s" placeholder="'.esc_attr__("What are you looking for?",'saor').'">';
		            echo '<button type="submit"><i class="fal fa-search"></i></button>';
		        echo '</form>';
		    echo '</div>';

		}elseif( $settings['layout_style'] == '2' ){

		    echo '<div class="th-header header-layout1 header-layout2 header-absolute">';
		        echo '<div class="sticky-wrapper '.esc_attr($sticky).'">';
		            echo '<div class="container th-container">';
		                echo '<div class="menu-area">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo saor_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                            echo '<nav class="main-menu d-none d-lg-inline-block">';
		                                if( ! empty( $settings['saor_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';
		                            echo '<div class="header-button">';
		                                echo '<button type="button" class="th-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-lg-block">';
		                            echo '<div class="header-button">';
		                               	if($settings['show_search_btn'] == 'yes'){
		                            		echo '<button type="button" class="icon-btn searchBoxToggler"><i class="fal fa-search"></i></button>';
		                            	}
		                                
		                                if( ! empty( $settings['button_text'] ) ){
		                                	echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style1 th-icon">'. wp_kses_post( $settings['button_text'] ).wp_kses_post( $settings['contact_icon'] ).'</a>';
		                            	}  
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		}elseif($settings['layout_style'] == '3'){

		    echo '<div class="th-header header-layout3 header-absolute">';
		        echo '<div class="header-top">';
		            echo '<div class="container th-container">';
		                echo '<div class="row justify-content-center justify-content-lg-between align-items-center">';
		                	if(!empty($settings['topbar_info_list'] )):
			                    echo '<div class="col-auto d-none d-md-block">';
			                       echo ' <div class="header-links">';
			                            echo '<ul>';
		                                	foreach( $settings['topbar_info_list'] as $data ){ 
			                                	echo '<li>'. wp_kses_post( $data['icon'] ).' '.wp_kses_post( $data['title'] ).'</li>';
			                                }
			                            echo '</ul>';
			                        echo '</div>';
			                    echo '</div>';
			                endif;    
		                    if(!empty($settings['social'] )):
			                    echo '<div class="col-auto">';
			                        echo '<div class="header-right">';
			                            echo '<p class="title">'.wp_kses_post( $settings['social_text'] ).'</p>';
			                            echo '<div class="social-links">';
			                                echo wp_kses_post( $settings['social'] );
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                endif;
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="sticky-wrapper '.esc_attr($sticky).'">';

		            echo '<div class="container th-container">';
		                echo '<div class="menu-area">';
		                   echo ' <div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
										echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo saor_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                            echo '</div>';
		                        echo '</div>';
		                       echo '<div class="col-auto">';
		                            echo '<nav class="main-menu d-none d-lg-inline-block">';
		                                if( ! empty( $settings['saor_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo ' </nav>';
		                            echo '<div class="header-button">';
		                                echo '<button type="button" class="th-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>';
		                            echo '</div>';
		                        echo '</div>';
		                       echo ' <div class="col-auto d-none d-lg-block">';
		                            echo '<div class="header-button">';
		                                if($settings['show_search_btn'] == 'yes'){
		                            		echo '<button type="button" class="icon-btn searchBoxToggler"><i class="fal fa-search"></i></button>';
		                            	}
		                                
		                                if( ! empty( $settings['button_text'] ) ){
		                                	echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style1 th-radius th-icon">'. wp_kses_post( $settings['button_text'] ).'</a>';
		                            	}  
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		}elseif($settings['layout_style'] == '4'){

			echo '<div class="th-header header-layout4 header-absolute">';
		       echo ' <div class="sticky-wrapper '.esc_attr($sticky).'">';

		            echo '<div class="container th-container">';
		                echo '<div class="menu-area">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a class="icon-masking" href='.esc_url( home_url( '/' ) ).'">';
			                               	echo saor_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
		                                echo '</a>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                            echo '<nav class="main-menu d-none d-lg-inline-block">';
		                                if( ! empty( $settings['saor_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';
		                            echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-lg-block">';
		                            echo '<div class="header-button">';
		                                if($settings['show_search_btn'] == 'yes'){
		                            		echo '<button type="button" class="icon-btn searchBoxToggler"><i class="fal fa-search"></i></button>';
		                            	}
		                                
		                                if( ! empty( $settings['button_text'] ) ){
		                                	echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn th-radius th-icon">'. wp_kses_post( $settings['button_text'] ).'</a>';
		                            	}  
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		       echo ' </div>';
		    echo '</div>';

		}elseif($settings['layout_style'] == '5'){

			 echo '<div class="th-header default-header header-absolute">';
		        echo '<div class="sticky-wrapper '.esc_attr($sticky).'">';
		            echo '<div class="container th-container">';
		                echo '<div class="menu-area">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo saor_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                            echo '<nav class="main-menu style2 d-none d-lg-inline-block">';
		                                if( ! empty( $settings['saor_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';
		                            echo '<div class="header-button">';
		                                echo '<button type="button" class="th-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-lg-block">';
		                            echo '<div class="header-button">';
		                            	if($settings['show_search_btn'] == 'yes'){
		                            		echo '<button type="button" class="icon-btn searchBoxToggler"><i class="fal fa-search"></i></button>';
		                            	}
		                                
		                                if( ! empty( $settings['button_text'] ) ){
		                                	echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn style1 th-icon">'. wp_kses_post( $settings['button_text'] ).'</a>';
		                            	}  

		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		    echo '<div class="popup-search-box d-none d-lg-block">';
		        echo '<button class="searchClose"><i class="fal fa-times"></i></button>';
		        echo '<form role="search" method="get" action="' . esc_url(home_url('/')) . '">';
		            echo '<input type="text" value="' . esc_html(get_search_query()) . '" name="s" placeholder="'.esc_attr__("What are you looking for?",'saor').'">';
		            echo '<button type="submit"><i class="fal fa-search"></i></button>';
		        echo '</form>';
		    echo '</div>';

		}elseif($settings['layout_style'] == '6'){

			echo '<div class="th-header header-layout5 header-absolute">';
		        echo '<div class="sticky-wrapper '.esc_attr($sticky).'">';

		            echo '<div class="container th-container4">';
		                echo '<div class="menu-area">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a href="'.esc_url( home_url( '/' ) ).'" class="icon-masking">';
											echo saor_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                            echo '</div>';
		                        echo ' </div>';
		                        echo '<div class="col-auto">';
		                            echo '<nav class="main-menu d-none d-lg-inline-block">';
		                                if( ! empty( $settings['saor_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';
		                            echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-lg-block">';
		                            echo '<div class="header-button">';
		                             	if($settings['show_offcanvas_btn'] == 'yes'){
		                                	echo '<a href="#" class="icon-btn sideMenuToggler"><i class="fa-solid fa-bars-sort"></i></a>';
		                                }
		                                if($settings['show_search_btn'] == 'yes'){
		                                	echo '<button type="button" class="icon-btn th-radius searchBoxToggler"><i class="far fa-search"></i></button>';
		                                }	
		                            echo '</div>';
		                       echo ' </div>';
		                    echo '</div>';
		               echo ' </div>';
		           echo ' </div>';
		       echo ' </div>';
		    echo '</div>';

		}elseif($settings['layout_style'] == '7'){

			echo '<div class="th-header header-layout1 header-layout6 header-absolute">';
		        echo '<div class="sticky-wrapper '.esc_attr($sticky).'">';
		            echo '<div class="container th-container">';
		                echo '<div class="menu-area">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                               	echo '<a href="'.esc_url( home_url( '/' ) ).'">';
											echo saor_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                                echo '<span class="shape"></span>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                            echo '<nav class="main-menu d-none d-lg-inline-block">';
		                                if( ! empty( $settings['saor_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';
		                            echo '<div class="header-button">';
		                                echo '<button type="button" class="th-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-lg-block">';
		                            echo '<div class="header-button">';
		                             	if($settings['show_search_btn'] == 'yes'){
		                               		echo '<button type="button" class="icon-btn searchBoxToggler"><i class="fal fa-search"></i></button>';
		                               	}
		                               	if(!empty($settings['button_text'])){
		                                	echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn th-radius3 th-icon">'. wp_kses_post( $settings['button_text'] ).' <i class="fa-regular fa-arrow-right ms-2"></i></a>';
		                                }
		                            echo '</div>';
		                       echo ' </div>';
		                    echo '</div>';
		               echo ' </div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';

		}elseif($settings['layout_style'] == '8'){

		    echo '<div class="th-header header-layout4 header-layout7 header-absolute">';
		        echo '<div class="sticky-wrapper">';
		            echo '<div class="container th-container">';
		                echo '<div class="menu-area">';
		                    echo '<div class="row align-items-center justify-content-between">';
		                        echo '<div class="col-auto">';
		                            echo '<div class="header-logo">';
		                                echo '<a href="'.esc_url( home_url( '/' ) ).'" class="icon-masking">';
											echo saor_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url'] ),
											));
										echo '</a>';
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<div class="col-auto">';
		                            echo '<nav class="main-menu d-none d-lg-inline-block">';
		                                if( ! empty( $settings['saor_menu_select'] ) ){
											wp_nav_menu( $args );
										}
		                            echo '</nav>';
		                            echo '<button type="button" class="th-menu-toggle d-block d-lg-none"><i class="far fa-bars"></i></button>';
		                        echo '</div>';
		                        echo '<div class="col-auto d-none d-lg-block">';
		                            echo '<div class="header-button">';
		                            	if($settings['show_search_btn'] == 'yes'){
		                                	echo '<button type="button" class="icon-btn th-radius searchBoxToggler"><i class="far fa-search"></i></button>';
		                                }
		                                if(!empty($settings['button_text'])){
		                                	echo '<a href="'.esc_url($settings['button_url']['url']).'" class="th-btn th-radius3 style1 th-icon">'. wp_kses_post( $settings['button_text'] ).' <i class="fa-regular fa-arrow-right ms-2"></i></a>';
		                                }
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		       echo ' </div>';
		    echo '</div>';

		}
		

	}
}