<?php
/**
 * NASS Payment Gateway Checkout Form
 * 
 * This template can be overridden by copying it to yourtheme/woocommerce/nass-payment-gateway/checkout-form.php
 *
 * @package NassPaymentGateway
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}
?>

<div id="nass-payment-form" class="nass-payment-form">
    <div class="nass-payment-description">
        <div class="nass-accepted-cards">
            <div class="card-icons">
                <svg width="40" height="25" viewBox="0 0 40 25" class="payment-icon visa">
                    <rect fill="#1a1f71" width="40" height="25" rx="4"/>
                    <text x="20" y="16" fill="white" font-family="Arial, sans-serif" font-size="8" font-weight="bold" text-anchor="middle">VISA</text>
                </svg>
                <svg width="40" height="25" viewBox="0 0 40 25" class="payment-icon mastercard">
                    <rect fill="#eb001b" width="40" height="25" rx="4"/>
                    <circle cx="15" cy="12.5" r="7" fill="#ff5f00"/>
                    <circle cx="25" cy="12.5" r="7" fill="#f79e1b"/>
                </svg>
            </div>
        </div>
        <p class="nass-security-note">
            <span class="dashicons dashicons-lock"></span>
            <?php _e('Your payment information is encrypted and secure', 'nass-payment-gateway'); ?>
        </p>
    </div>
    
    <!-- Card Input Fields -->
    <div class="nass-card-fields">
        <div class="form-row form-row-wide">
            <label for="nass_card_number"><?php _e('Card Number', 'nass-payment-gateway'); ?> <span class="required">*</span></label>
            <input type="text" class="input-text" id="nass_card_number" name="nass_card_number" placeholder="1234 5678 9012 3456" maxlength="19" autocomplete="cc-number" />
        </div>
        
        <div class="form-row form-row-wide">
            <label for="nass_card_name"><?php _e('Cardholder Name', 'nass-payment-gateway'); ?> <span class="required">*</span></label>
            <input type="text" class="input-text" id="nass_card_name" name="nass_card_name" placeholder="John Doe" autocomplete="cc-name" />
        </div>
        
        <div class="form-row form-row-first">
            <label for="nass_card_expiry"><?php _e('Expiry Date', 'nass-payment-gateway'); ?> <span class="required">*</span></label>
            <input type="text" class="input-text" id="nass_card_expiry" name="nass_card_expiry" placeholder="MM/YY" maxlength="5" autocomplete="cc-exp" />
        </div>
        
        <div class="form-row form-row-last">
            <label for="nass_card_cvv"><?php _e('CVV', 'nass-payment-gateway'); ?> <span class="required">*</span></label>
            <input type="text" class="input-text" id="nass_card_cvv" name="nass_card_cvv" placeholder="123" maxlength="4" autocomplete="cc-csc" />
        </div>
    </div>
    
    <div class="nass-test-mode-notice" style="<?php echo ('sandbox' === get_option('woocommerce_nass_gateway_environment', 'sandbox')) ? 'display: block;' : 'display: none;'; ?>">
        <div class="test-notice">
            <span class="dashicons dashicons-warning"></span>
            <strong><?php _e('TEST MODE ACTIVE', 'nass-payment-gateway'); ?></strong>
            <p><?php _e('This payment gateway is in test mode. Use test card numbers for testing.', 'nass-payment-gateway'); ?></p>
            <details>
                <summary><?php _e('Test Card Numbers', 'nass-payment-gateway'); ?></summary>
                <div class="test-cards">
                    <p><strong>Visa:</strong> 4761349999000039</p>
                    <p><strong>Mastercard:</strong> 5185520050000010</p>
                    <p><strong>Expiry:</strong> 12/25 or 12/31</p>
                    <p><strong>CVV:</strong> 356</p>
                </div>
            </details>
        </div>
    </div>
    
    <!-- Hidden fields for processing -->
    <input type="hidden" id="nass_payment_method" name="payment_method" value="nass_gateway" />
    
    <!-- Loading overlay -->
    <div class="nass-loading-overlay" style="display: none;">
        <div class="loading-content">
            <div class="spinner"></div>
            <p><?php _e('Processing payment...', 'nass-payment-gateway'); ?></p>
        </div>
    </div>
</div>

<style>
/* Card input fields styling */
.nass-card-fields {
    background: white;
    border: 1px solid #ddd;
    border-radius: 6px;
    padding: 20px;
    margin: 20px 0;
}

.nass-card-fields .form-row {
    margin-bottom: 15px;
}

.nass-card-fields label {
    display: block;
    margin-bottom: 5px;
    font-weight: 600;
    color: #333;
}

.nass-card-fields input {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 16px;
    box-sizing: border-box;
}

.nass-card-fields input:focus {
    border-color: #3498db;
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.nass-card-fields .form-row-first {
    float: left;
    width: 48%;
    margin-right: 4%;
}

.nass-card-fields .form-row-last {
    float: left;
    width: 48%;
}

.nass-card-fields:after {
    content: "";
    display: table;
    clear: both;
}

/* Rest of existing styles... */
.nass-payment-form {
    background: #f9f9f9;
    border: 1px solid #e1e1e1;
    border-radius: 8px;
    padding: 20px;
    margin: 15px 0;
    position: relative;
}

.nass-accepted-cards {
    text-align: center;
    margin-bottom: 15px;
}

.card-icons {
    display: flex;
    justify-content: center;
    gap: 10px;
    margin-bottom: 10px;
}

.payment-icon {
    border-radius: 4px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.nass-security-note {
    color: #666;
    font-size: 14px;
    margin: 0;
    display: flex;
    align-items: center;
    justify-content: center;
}

.nass-security-note .dashicons {
    margin-right: 5px;
    color: #27ae60;
}

.nass-test-mode-notice {
    background: #fff3cd;
    border: 1px solid #ffc107;
    border-radius: 6px;
    padding: 15px;
    margin: 15px 0;
}

.test-notice {
    text-align: center;
}

.test-notice .dashicons {
    color: #856404;
    margin-right: 5px;
}

.test-notice strong {
    color: #856404;
    display: block;
    margin-bottom: 5px;
}

.test-notice p {
    margin: 5px 0;
    font-size: 14px;
}

.test-cards {
    text-align: left;
    margin-top: 10px;
    font-family: monospace;
    font-size: 13px;
}

.nass-loading-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.95);
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 8px;
}

.loading-content {
    text-align: center;
}

.spinner {
    border: 3px solid #f3f3f3;
    border-top: 3px solid #3498db;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    animation: spin 1s linear infinite;
    margin: 0 auto 15px;
}

@keyframes spin {
   0% { transform: rotate(0deg); }
   100% { transform: rotate(360deg); }
}

/* Responsive design */
@media (max-width: 768px) {
   .nass-payment-form {
       padding: 15px;
   }
   
   .nass-card-fields .form-row-first,
   .nass-card-fields .form-row-last {
       float: none;
       width: 100%;
       margin-right: 0;
   }
}
</style>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Format card number as user types
    $('#nass_card_number').on('input', function() {
        var value = $(this).val().replace(/\s+/g, '').replace(/[^0-9]/gi, '');
        var formattedValue = value.match(/.{1,4}/g)?.join(' ') || value;
        $(this).val(formattedValue);
    });
    
    // Format expiry date as user types
    $('#nass_card_expiry').on('input', function() {
        var value = $(this).val().replace(/\s+/g, '').replace(/[^0-9]/gi, '');
        if (value.length >= 2) {
            value = value.substring(0, 2) + '/' + value.substring(2, 4);
        }
        $(this).val(value);
    });
    
    // Only allow numbers in CVV
    $('#nass_card_cvv').on('input', function() {
        $(this).val($(this).val().replace(/[^0-9]/g, ''));
    });
    
    // Validation on form submit
    $('form.checkout').on('checkout_place_order_nass_gateway', function() {
        var isValid = true;
        var errors = [];
        
        // Validate card number
        var cardNumber = $('#nass_card_number').val().replace(/\s+/g, '');
        if (cardNumber.length < 13 || cardNumber.length > 19) {
            isValid = false;
            errors.push('Please enter a valid card number');
            $('#nass_card_number').addClass('error');
        }
        
        // Validate cardholder name
        if ($('#nass_card_name').val().trim() === '') {
            isValid = false;
            errors.push('Please enter cardholder name');
            $('#nass_card_name').addClass('error');
        }
        
        // Validate expiry
        var expiry = $('#nass_card_expiry').val();
        if (!expiry.match(/^(0[1-9]|1[0-2])\/\d{2}$/)) {
            isValid = false;
            errors.push('Please enter valid expiry date (MM/YY)');
            $('#nass_card_expiry').addClass('error');
        }
        
        // Validate CVV
        var cvv = $('#nass_card_cvv').val();
        if (cvv.length < 3 || cvv.length > 4) {
            isValid = false;
            errors.push('Please enter valid CVV');
            $('#nass_card_cvv').addClass('error');
        }
        
        if (!isValid) {
            alert(errors.join('\n'));
            return false;
        }
        
        $('.nass-loading-overlay').show();
        return true;
    });
    
    // Remove error class on input
    $('.nass-card-fields input').on('input', function() {
        $(this).removeClass('error');
    });
    
    // Test card click to fill
    $('.test-cards p').on('click', function() {
        var text = $(this).text();
        var match = text.match(/:\s*(.+)/);
        if (match) {
            var value = match[1];
            if (text.includes('Visa') || text.includes('Mastercard')) {
                $('#nass_card_number').val(value).trigger('input');
            } else if (text.includes('Expiry')) {
                $('#nass_card_expiry').val('12/25');
            } else if (text.includes('CVV')) {
                $('#nass_card_cvv').val(value);
            }
        }
    });
});
</script>