<?php
/**
 * NASS API Direct Test
 * Place this in WordPress root and access via browser
 */

// Configuration
$config = array(
    'username' => 'info@epicstore-key.com',
    'password' => 'Epicstore@2025?',
    'terminal_id' => '00099619',
    'api_url' => 'https://uat-gateway.nass.iq:9746/',
);

// Test order ID
$test_order_id = $_GET['order_id'] ?? 'TEST-1749136557';

echo "<h1>NASS API Direct Test</h1>";
echo "<pre style='background: #f0f0f0; padding: 20px;'>";

// Step 1: Authenticate
echo "=== STEP 1: AUTHENTICATION ===\n\n";

$ch = curl_init($config['api_url'] . 'auth/merchant/login');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
    'username' => $config['username'],
    'password' => $config['password']
]));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $http_code\n";
echo "Response: " . $response . "\n\n";

$auth_data = json_decode($response, true);

if ($auth_data['success'] && isset($auth_data['data']['access_token'])) {
    $token = $auth_data['data']['access_token'];
    echo "✅ Authentication successful!\n";
    echo "Token: " . substr($token, 0, 50) . "...\n\n";
    
    // Step 2: Check transaction status
    echo "=== STEP 2: CHECK TRANSACTION STATUS ===\n\n";
    echo "Checking status for order: $test_order_id\n\n";
    
    $ch = curl_init($config['api_url'] . 'transaction/' . $test_order_id . '/checkStatus');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $token,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "HTTP Code: $http_code\n";
    echo "Response: " . $response . "\n\n";
    
    $status_data = json_decode($response, true);
    
    if ($status_data) {
        echo "Parsed Response:\n";
        print_r($status_data);
        
        if (isset($status_data['data'])) {
            echo "\n=== TRANSACTION DETAILS ===\n";
            echo "Status: " . ($status_data['data']['statusMsg'] ?? 'Unknown') . "\n";
            echo "Response Code: " . ($status_data['data']['responseCode'] ?? 'Unknown') . "\n";
            echo "RRN: " . ($status_data['data']['rrn'] ?? 'Not provided') . "\n";
            echo "Action Code: " . ($status_data['data']['actionCode'] ?? 'Unknown') . "\n";
        }
    }
    
    // Step 3: Create a new test transaction
    echo "\n\n=== STEP 3: CREATE NEW TEST TRANSACTION ===\n\n";
    
    $new_order_id = 'API-TEST-' . time();
    $transaction_data = [
        'orderId' => $new_order_id,
        'orderDesc' => 'API Test Payment',
        'amount' => '1000.00',
        'currency' => '368',
        'transactionType' => '1',
        'backRef' => 'https://sailofexcellence.com/checkout-test-rrn.php',
        'notifyUrl' => 'https://sailofexcellence.com/checkout-test-rrn.php'
    ];
    
    echo "Creating transaction with data:\n";
    print_r($transaction_data);
    echo "\n";
    
    $ch = curl_init($config['api_url'] . 'transaction');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($transaction_data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $token,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "HTTP Code: $http_code\n";
    echo "Response: " . $response . "\n\n";
    
    $transaction_response = json_decode($response, true);
    
    if ($transaction_response && $transaction_response['success']) {
        echo "✅ Transaction created successfully!\n\n";
        echo "Payment URL: " . $transaction_response['data']['url'] . "\n\n";
        echo "Transaction Parameters:\n";
        print_r($transaction_response['data']['transactionParams']);
        
        echo "\n\n=== STEP 4: DIRECT API PAYMENT TEST ===\n\n";
        echo "Testing Direct API Integration (without redirect)...\n\n";
        
        // Extract parameters from transaction response
        $params = $transaction_response['data']['transactionParams'];
        $pSign = $transaction_response['data']['pSign'];
        
        // Prepare direct payment request
        $direct_payment_data = [
            'card' => '4761349999000039',  // Test Visa card
            'expMonth' => '12',
            'expYear' => '31',
            'currency' => '368',
            'name' => 'Test User',
            'trtype' => '1',
            'terminal' => $config['terminal_id'],
            'desc' => $transaction_data['orderDesc'],
            'cvc2_rc' => '0',  // CVV not provided
            'orderId' => $new_order_id,
            'timestamp' => $params['TIMESTAMP'],
            'nonce' => $params['NONCE'],
            'p_sign' => $pSign,
            'amount' => str_replace('.00', '', $transaction_data['amount']), // Remove decimals
            'cvc2' => '',  // Empty CVV
            'backRefUrl' => $transaction_data['backRef']
        ];
        
        echo "Direct payment request data:\n";
        print_r($direct_payment_data);
        echo "\n";
        
        // Make direct payment request
        $ch = curl_init('https://3dsecure.nass.iq/cgi-bin/cgi_json');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($direct_payment_data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curl_error = curl_error($ch);
        curl_close($ch);
        
        echo "Direct API HTTP Code: $http_code\n";
        if ($curl_error) {
            echo "cURL Error: $curl_error\n";
        }
        echo "\nDirect API Response:\n";
        echo "--------------------\n";
        echo htmlspecialchars($response);
        echo "\n--------------------\n";
        
        // Try to parse if it's JSON
        $json_response = json_decode($response, true);
        if ($json_response) {
            echo "\nParsed JSON Response:\n";
            print_r($json_response);
        }
    } else {
        echo "❌ Failed to create transaction\n";
        if ($transaction_response) {
            print_r($transaction_response);
        }
    }
    
} else {
    echo "❌ Authentication failed!\n";
    print_r($auth_data);
}

echo "</pre>";

echo "<div style='margin: 20px 0;'>";
echo "<h2>Test Other Orders:</h2>";
echo "<form method='GET' style='display: inline-block; margin-right: 10px;'>";
echo "<input type='text' name='order_id' placeholder='Enter Order ID' value='" . htmlspecialchars($test_order_id) . "'>";
echo "<button type='submit'>Check Status</button>";
echo "</form>";
echo "</div>";

echo "<div style='background: #fff3cd; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
echo "<h3>Error Codes Reference:</h3>";
echo "<ul>";
echo "<li><strong>-8</strong>: Error in card number field</li>";
echo "<li><strong>-9</strong>: Error in card expiration date field</li>";
echo "<li><strong>-18</strong>: Error in CVV2 fields</li>";
echo "<li><strong>-21</strong>: Transaction already executed</li>";
echo "<li><strong>-25</strong>: Transaction cancelled by user</li>";
echo "<li><strong>-30</strong>: Transaction declined as fraud</li>";
echo "<li><strong>-32</strong>: Repeated declined transaction</li>";
echo "</ul>";
echo "</div>";
?>